/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.module;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.tooling.core.IconsLocator;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.icons.ImagesManager;
import org.mule.tooling.images.StudioImages;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitor;
import org.mule.tooling.model.module.IPropertyPagesProvider;
import org.mule.tooling.model.module.IRequirementsProvider;
import org.mule.tooling.model.module.Keyword;
import org.mule.tooling.model.module.PropertyPageDefinition;
import org.mule.tooling.model.module.Requirement;
import org.mule.tooling.model.module.filter.DefaultFilter;
import org.mule.tooling.model.module.filter.DefaultLocationFilter;
import org.mule.tooling.model.module.filter.ILocationFilter;
import org.mule.tooling.model.module.filter.INodeDefinitionFilter;
import org.mule.tooling.utils.TypeContainer;

public abstract class NodeDefinition
implements Comparable<NodeDefinition>,
Cloneable {
    private String id;
    private String name;
    private String description;
    private ImageDescriptor image;
    private String categoryId;
    private String paletteCategoryId;
    private String minimumVersion;
    private Class<?> xmlGenerator;
    private Class<?> modelGenerator;
    private Class<?> actionDelegate;
    private List<Keyword> keywords;
    private String titleColor;
    private String elementMatcher;
    private IPropertyPagesProvider propertyPagesProvider;
    protected final ArrayList<NodeDefinition> alternativeIds = new ArrayList();
    protected TypeContainer data = new TypeContainer();
    protected boolean isAbstract;
    protected boolean isOverriden;
    protected boolean isVisibleInPalette = true;
    protected String extendsDefinition;
    private List<PropertyPageDefinition> propertyPages = new ArrayList<PropertyPageDefinition>();
    protected String wrapInLocal;
    private boolean hiddenFromXML;
    private String defaultDocName = null;
    private String completionProposalDocName = null;
    private boolean shownInXML = false;
    private INodeDefinitionFilter acceptedByFilter = DefaultFilter.getInstance();
    private ILocationFilter locationFilter = DefaultLocationFilter.getInstance();
    private String displayNameAtribute;
    private String bundleSymbolicName;
    private boolean allowsName = true;
    private boolean allowsDescription = true;
    private List<String> errorTypes = Lists.newArrayList();
    private List<Requirement> requirements = Lists.newArrayList();
    private String plugin;
    private String iconPath;
    private String imagePath;
    private Stereotype stereotype;

    public NodeDefinition() {
        this.alternativeIds.add(this);
    }

    public String getElementMatcher() {
        return this.elementMatcher;
    }

    public void setElementMatcher(String elementMatcher) {
        this.elementMatcher = elementMatcher;
    }

    public void setPropertyPagesProvider(IPropertyPagesProvider propertyPagesProvider) {
        this.propertyPagesProvider = propertyPagesProvider;
    }

    public List<NodeDefinition> getAlternativeIds() {
        return this.alternativeIds;
    }

    public List<String> getAlternativeIdsTypes() {
        ArrayList<String> types = new ArrayList<String>();
        if (this.alternativeIds != null) {
            for (NodeDefinition nodeDefinition : this.alternativeIds) {
                types.add(nodeDefinition.getId());
            }
        }
        return types;
    }

    public boolean isVisibleInPalette() {
        return this.isVisibleInPalette;
    }

    public void setVisibleInPalette(boolean isVisible) {
        this.isVisibleInPalette = isVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeDefinition> getAlternativeIdsCopy() {
        if (this.alternativeIds == null) {
            return null;
        }
        ArrayList<NodeDefinition> arrayList = this.alternativeIds;
        synchronized (arrayList) {
            return new ArrayList<NodeDefinition>(this.alternativeIds);
        }
    }

    public INodeDefinitionFilter getAcceptedByFilter() {
        return this.acceptedByFilter;
    }

    public void setAcceptedByFilter(INodeDefinitionFilter validContainerFilter) {
        this.acceptedByFilter = validContainerFilter;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public String getExtendsDefinition() {
        return this.extendsDefinition;
    }

    public void setExtendsDefinition(String extendsDefinition) {
        this.extendsDefinition = extendsDefinition;
    }

    public <T> T getService(Class<T> clazz) {
        return this.data.getType(clazz).orElse(null);
    }

    public <T> T findServiceImplements(Class<T> clazz) {
        Collection keySet = this.data.getRegisteredTypes();
        for (Class key : keySet) {
            if (!clazz.isAssignableFrom(key)) continue;
            return clazz.cast(this.data.getType(key).get());
        }
        return null;
    }

    public <T> void registerService(Class<? super T> clazz, T element) {
        this.data.putType(clazz, element);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImageDescriptor getIcon() {
        ImageDescriptor descriptor = IconsLocator.getDescriptor(this.getIconPath());
        return descriptor != null ? descriptor : StudioImages.PALETTE_GENERIC;
    }

    public Image getIconImage() {
        return Optional.ofNullable(IconsLocator.getImage(this.getIconPath())).orElseGet(() -> ImagesManager.getInstance().getPaletteUnknown());
    }

    public Image getCanvasImage() {
        return Optional.ofNullable(IconsLocator.getImage(this.getImagePath())).orElseGet(() -> ImagesManager.getInstance().getCanvasUnknown());
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setIconPath(String plugin, String iconPath) {
        this.plugin = plugin;
        this.iconPath = iconPath;
    }

    public ImageDescriptor getImage() {
        if (this.image == null && StringUtils.isNotBlank((String)this.plugin) && StringUtils.isNotBlank((String)this.imagePath)) {
            this.image = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.plugin, (String)this.imagePath);
        }
        return this.image;
    }

    public void setImagePath(String plugin, String imagePath) {
        this.plugin = plugin;
        this.imagePath = imagePath;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getPaletteCategoryId() {
        return StringUtils.isEmpty((String)this.paletteCategoryId) ? this.getCategoryId() : this.paletteCategoryId;
    }

    public void setPaletteCategoryId(String palleteCategoryId) {
        this.paletteCategoryId = palleteCategoryId;
    }

    public String getMinimumVersion() {
        return this.minimumVersion;
    }

    public void setMinimumVersion(String minimumVersion) {
        this.minimumVersion = minimumVersion;
    }

    public Class<?> getXmlGenerator() {
        return this.xmlGenerator;
    }

    public void setXmlGenerator(Class<?> xmlGenerator) {
        this.xmlGenerator = xmlGenerator;
    }

    public Class<?> getModelGenerator() {
        return this.modelGenerator;
    }

    public void setModelGenerator(Class<?> modelGenerator) {
        this.modelGenerator = modelGenerator;
    }

    public void setPropertyPages(List<PropertyPageDefinition> propertyPages) {
        this.propertyPages = propertyPages;
    }

    public List<PropertyPageDefinition> getPropertyPages(Object ctx) {
        if (this.propertyPagesProvider != null) {
            return this.propertyPagesProvider.getPropertyPages(ctx);
        }
        return this.propertyPages;
    }

    public Class<?> getActionDelegate() {
        return this.actionDelegate;
    }

    public void setActionDelegate(Class<?> actionDelegate) {
        this.actionDelegate = actionDelegate;
    }

    @Override
    public int compareTo(NodeDefinition o) {
        return this.getName().compareTo(o.getName());
    }

    public abstract boolean matches(QName var1);

    public <T extends NodeDefinition> boolean is(Class<T> clazz) {
        return clazz.isAssignableFrom(this.getClass());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setOverriden(boolean b) {
        this.isOverriden = b;
    }

    public boolean isOverriden() {
        return this.isOverriden;
    }

    public void addAlternative(NodeDefinition rd) {
        this.alternativeIds.add(rd);
    }

    public void setWrapIn(String localName) {
        this.wrapInLocal = localName;
    }

    public String getWrapInLocal() {
        return this.wrapInLocal;
    }

    public void setHiddenFromXML(boolean hiddenFromXML) {
        this.hiddenFromXML = hiddenFromXML;
    }

    public boolean isHiddenFromXML() {
        return this.hiddenFromXML;
    }

    public boolean isShownInXML() {
        return this.shownInXML;
    }

    public void setShownInXML(boolean shownInXML) {
        this.shownInXML = shownInXML;
    }

    public boolean getAllowsName() {
        return this.allowsName;
    }

    public void setAllowsName(boolean allowsName) {
        this.allowsName = allowsName;
    }

    public boolean getAllowsDescription() {
        return this.allowsDescription;
    }

    public void setAllowsDescription(boolean allowsDescription) {
        this.allowsDescription = allowsDescription;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getId() + ")";
    }

    public String getDefaultDocName() {
        return this.defaultDocName;
    }

    public void setDefaultDocName(String defaultDocName) {
        this.defaultDocName = defaultDocName;
    }

    public String getDocName() {
        return this.defaultDocName != null ? this.defaultDocName : this.name;
    }

    public String getCompletionProposalDocName() {
        return this.completionProposalDocName;
    }

    public void setCompletionProposalDocName(String completionProposalDocName) {
        this.completionProposalDocName = completionProposalDocName;
    }

    public List<Keyword> getKeywords() {
        return this.keywords == null ? Collections.emptyList() : this.keywords;
    }

    public void setKeywords(List<Keyword> keywords) {
        this.keywords = keywords;
    }

    public abstract void accept(NodeDefinitionVisitor var1);

    public ILocationFilter getLocationFilter() {
        return this.locationFilter;
    }

    public void setLocationFilter(ILocationFilter locationFilter) {
        this.locationFilter = locationFilter;
    }

    public String getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(String titleColor) {
        this.titleColor = titleColor;
    }

    public boolean isUseDocNameAsDisplayName() {
        return StringUtils.isEmpty((String)this.displayNameAtribute);
    }

    public String getDisplayNameAtribute() {
        return this.displayNameAtribute;
    }

    public void setDisplayNameAtribute(String displayNameAtribute) {
        this.displayNameAtribute = displayNameAtribute;
    }

    public void setBundleSymbolicName(String bundleSymbolicName) {
        this.bundleSymbolicName = bundleSymbolicName;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public void addRequirement(Requirement requirement) {
        this.requirements.add(requirement);
    }

    public void addRequirements(Collection<Requirement> requirements) {
        requirements.addAll(requirements);
    }

    public Collection<Requirement> getRequirements() {
        IRequirementsProvider service = this.getService(IRequirementsProvider.class);
        if (service == null) {
            return ImmutableList.copyOf(this.requirements);
        }
        return service.getRequirements();
    }

    public void addErrorTypes(Collection<String> errorTypes) {
        this.errorTypes.addAll(errorTypes);
    }

    public Collection<String> getErrorTypes() {
        return this.errorTypes;
    }

    public Stereotype getStereotype() {
        return this.stereotype;
    }

    public void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeDefinition other = (NodeDefinition)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

