/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.model.messageflow.IPathExpression;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitor;
import org.mule.tooling.model.module.GraphicalContainerDefinition;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;

public class ContainerDefinition
extends NodeDefinition
implements IPathExpression {
    private QName muleElement;
    private List<NestedContainerDefinition> nestedContainerDefinitions;
    private String containerBehavior;
    private String pathExpression;
    private String defaultNestedContainer;

    @Override
    public boolean matches(QName name) {
        return this.muleElement.equals(name);
    }

    @Override
    public void accept(NodeDefinitionVisitor visitor) {
        visitor.visitContainerDefinition(this);
    }

    public QName getMuleElement() {
        return this.muleElement;
    }

    public void setMuleElement(QName muleElement) {
        this.muleElement = muleElement;
    }

    public List<NestedContainerDefinition> getNestedContainerDefinitions() {
        return this.nestedContainerDefinitions;
    }

    public void setNestedContainerDefinitions(List<NestedContainerDefinition> nestedContainerDefinitions) {
        this.nestedContainerDefinitions = nestedContainerDefinitions;
        boolean defaultFound = false;
        for (NestedContainerDefinition nestedDefinition : nestedContainerDefinitions) {
            if (!nestedDefinition.isDefault()) continue;
            if (defaultFound) {
                throw new IllegalArgumentException("Only one default nested container definition can be set.");
            }
            defaultFound = true;
        }
    }

    public List<GraphicalContainerDefinition> getGraphicalContainerDefinitions() {
        ArrayList<GraphicalContainerDefinition> graphicalDefinitions = new ArrayList<GraphicalContainerDefinition>();
        for (NestedContainerDefinition nestedDefinition : this.nestedContainerDefinitions) {
            if (!(nestedDefinition instanceof GraphicalContainerDefinition)) continue;
            graphicalDefinitions.add((GraphicalContainerDefinition)nestedDefinition);
        }
        return graphicalDefinitions;
    }

    public NestedContainerDefinition getNestedContainerDefinition(String type) {
        List<NestedContainerDefinition> nestedContainerDefinitions = this.getNestedContainerDefinitions();
        for (NestedContainerDefinition nestedContainerDefinition : nestedContainerDefinitions) {
            if (!nestedContainerDefinition.getId().equals(type)) continue;
            return nestedContainerDefinition;
        }
        return null;
    }

    public NestedContainerDefinition getDefaultContainerDefinition() {
        if (StringUtils.isEmpty((String)this.defaultNestedContainer)) {
            if (this.getNestedContainerDefinitions().isEmpty()) {
                throw new RuntimeException(this.getId() + " does not have nested container definitions. Looks like something is wrong");
            }
            return this.getNestedContainerDefinitions().get(0);
        }
        return this.getNestedContainerDefinition(this.defaultNestedContainer);
    }

    public List<NestedContainerDefinition> getNestedContainerDefinition(int rowNumber) {
        ArrayList defsForRow = Lists.newArrayList();
        List<NestedContainerDefinition> nestedContainerDefinitions = this.getNestedContainerDefinitions();
        for (NestedContainerDefinition nestedContainerDefinition : nestedContainerDefinitions) {
            if (nestedContainerDefinition.getRowNumber() != rowNumber) continue;
            defsForRow.add(nestedContainerDefinition);
        }
        return defsForRow;
    }

    public void setContainerBehavior(String containerBehavior) {
        this.containerBehavior = containerBehavior;
    }

    public String getContainerBehavior() {
        return this.containerBehavior;
    }

    public void setPathExpression(String pathExpression) {
        this.pathExpression = pathExpression;
    }

    @Override
    public String getPathExpression() {
        return this.pathExpression;
    }

    public void setDefaultContainerId(String defaultNestedContainer) {
        this.defaultNestedContainer = defaultNestedContainer;
    }
}

