/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow.util;

import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.util.AbstractMessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.AbstractMessageProcessorNode;
import org.mule.tooling.model.messageflow.util.BranchMessageProcessorNode;
import org.mule.tooling.model.messageflow.util.IMessageProcessorNode;
import org.mule.tooling.model.messageflow.util.MessageProcessorNode;
import org.mule.tooling.model.messageflow.util.MuleConfigurationProcessorNode;
import org.mule.tooling.model.messageflow.util.RootAwareEntityVisitor;
import org.mule.tooling.model.messageflow.util.TreeMuleConfiguration;

public class TreeMuleConfigurationGenerator {
    public TreeMuleConfiguration generateTreeConfiguration(MuleConfiguration muleConfiguration) {
        return this.generateTreeConfiguration(muleConfiguration, new TreeMuleConfigurationVisitor());
    }

    public TreeMuleConfiguration generateTreeConfiguration(MuleConfiguration muleConfiguration, RootAwareEntityVisitor visitor) {
        muleConfiguration.accept(visitor);
        return new TreeMuleConfiguration(visitor.getRoot());
    }

    private static class TreeMuleConfigurationVisitor
    extends AbstractMessageFlowEntityVisitor
    implements RootAwareEntityVisitor {
        private IMessageProcessorNode<MuleConfiguration> root;
        private IMessageProcessorNode<? extends MessageFlowEntity> current;

        private TreeMuleConfigurationVisitor() {
        }

        @Override
        public void visitEndpointNode(EndpointNode endpointNode) {
            this.current.addChild(new MessageProcessorNode<EndpointNode>(endpointNode));
        }

        @Override
        public void visitPatternNode(PatternNode patternNode) {
            this.current.addChild(new MessageProcessorNode<PatternNode>(patternNode));
        }

        @Override
        public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
            this.current.addChild(new MessageProcessorNode<GlobalUnknown>(globalUnknown));
        }

        @Override
        public void visitUnknownNode(UnknownNode unknownNode) {
            this.current.addChild(new MessageProcessorNode<UnknownNode>(unknownNode));
        }

        @Override
        public void visitCommentNode(CommentContainer unknownNode) {
            this.current.addChild(new MessageProcessorNode<CommentContainer>(unknownNode));
        }

        @Override
        public boolean preMuleConfiguration(MuleConfiguration muleConfiguration) {
            this.root = new MuleConfigurationProcessorNode(muleConfiguration);
            this.current = this.root;
            return true;
        }

        @Override
        public void preChildrenVisit(MessageFlowEntity entity) {
            AbstractMessageProcessorNode messageProcessorNode = this.current.getValue() instanceof SplitterNode ? new BranchMessageProcessorNode<MessageFlowEntity>(entity) : new MessageProcessorNode<MessageFlowEntity>(entity);
            this.current.addChild(messageProcessorNode);
            this.current = messageProcessorNode;
        }

        @Override
        public void postChildrenVisit(MessageFlowEntity entity) {
            this.current = this.current.getParent();
        }

        @Override
        public IMessageProcessorNode<MuleConfiguration> getRoot() {
            return this.root;
        }
    }
}

