/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.ReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;

public final class PropertiesUtils {
    public static final String ID_PREFIX = "@";
    public static final String ID_SEPARATOR = ";";
    private static final Pattern PROPERTY_COLLECTION_KEY_PATTERN = Pattern.compile("@([^;]+);.*");
    public static final String DOC_PREFIX = "doc:";
    public static final String DOC_COMPONENT_ID = "doc:id";
    public static final String DOC_NAME_ATTRIBUTE_ID = "doc:name";
    public static final String AUXILIARY_PREFIX = "auxiliary;";
    public static final String AUXILIARY_META = "auxiliary;meta";
    public static final String AUXILIARY_INDEX = "auxiliary;index";
    public static final String AUXILIARY_ERASED = "auxiliary;erased;";
    public static final String AUXILIARY_MOVED_FROM = "auxiliary;moved-from";
    public static final String AUXILIARY_METADATA = "auxiliary;metauseMetaData";
    public static final String EXCHANGE_PATTERN = "exchange-pattern";

    private PropertiesUtils() {
    }

    public static IReadOnlyProperty getProperty(IMessageFlowNode messageFlowNode, String property) {
        return messageFlowNode.getProperties() != null ? (IReadOnlyProperty)messageFlowNode.getProperties().getProperty(property) : null;
    }

    public static IReadOnlyProperty findPropertyByName(IMessageFlowNode node, String name) {
        if (node == null) {
            return null;
        }
        return PropertiesUtils.findPropertyByName(node.getProperties(), name);
    }

    public static IReadOnlyProperty findAuxiliaryPropertyByName(IMessageFlowNode node, String name) {
        return PropertiesUtils.findPropertyByName(node.getProperties(), AUXILIARY_META + name);
    }

    public static <PC, P extends IReadOnlyProperty> IReadOnlyProperty findAuxiliaryPropertyByName(IPropertyCollectionReadCapability<PC, P> props, String name) {
        return PropertiesUtils.findPropertyByName(props, AUXILIARY_META + name);
    }

    public static <PC, P extends IReadOnlyProperty> IReadOnlyProperty findPropertyByName(IPropertyCollectionReadCapability<PC, P> props, String name) {
        if (props == null) {
            return null;
        }
        return (IReadOnlyProperty)props.getProperty(name);
    }

    public static boolean checkAllPropertiesArePresentIn(List<? extends IReadOnlyProperty> source, List<? extends IReadOnlyProperty> target) {
        if (source == null || target == null) {
            return source == null && target == null;
        }
        for (IReadOnlyProperty iReadOnlyProperty : source) {
            if (PropertiesUtils.isAuxiliary(iReadOnlyProperty)) continue;
            IReadOnlyProperty findPropertyByName = PropertiesUtils.findPropertyReadOnlyByName(target, iReadOnlyProperty.getName());
            if (findPropertyByName == null) {
                return false;
            }
            if (findPropertyByName.getValue() == null && iReadOnlyProperty.getValue() != null) {
                return false;
            }
            if (findPropertyByName.getValue() == null || findPropertyByName.getValue().equals(iReadOnlyProperty.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean checkAllPropertyCollectionsPresentIn(List<? extends PropertyCollection> source, List<? extends PropertyCollection> target) {
        if (source == null || target == null) {
            return source == null && target == null;
        }
        for (PropertyCollection propertyCollection : source) {
            PropertyCollection findPropertyByName;
            if (propertyCollection.isErased() || propertyCollection.equals(findPropertyByName = PropertiesUtils.findPropertyCollectionByName(target, propertyCollection.getName()))) continue;
            return false;
        }
        return true;
    }

    public static PropertyCollection mergeProperties(IReadOnlyPropertyCollection sourceProperties, PropertyCollection propertiesToMerge) {
        List propertiesPromProjectList = sourceProperties.getProperties();
        List propertyCollectionsFromProject = sourceProperties.getPropertyCollections();
        propertiesPromProjectList.forEach(p -> {
            if (PropertiesUtils.findPropertyByName(propertiesToMerge.getProperties(), p.getName()) == null) {
                propertiesToMerge.addProperty(p.getName(), p.getValue());
            }
        });
        propertyCollectionsFromProject.forEach(pc -> {
            if (PropertiesUtils.findPropertyCollection(propertiesToMerge.getPropertyCollections(), pc.getName()) == null) {
                propertiesToMerge.addPropertyCollection(pc.toPropertyCollectionMap().asPropertyCollection());
            }
        });
        return propertiesToMerge;
    }

    private static boolean isAuxiliary(IReadOnlyProperty property) {
        return property.getName().startsWith(AUXILIARY_PREFIX);
    }

    public static IReadOnlyProperty findPropertyReadOnlyByName(List<? extends IReadOnlyProperty> props, String name) {
        for (IReadOnlyProperty iReadOnlyProperty : props) {
            if (!iReadOnlyProperty.getName().equals(name)) continue;
            return iReadOnlyProperty;
        }
        return null;
    }

    public static PropertyCollection findPropertyCollectionByName(List<? extends PropertyCollection> props, String name) {
        for (PropertyCollection propertyCollection : props) {
            if (!propertyCollection.getName().equals(name)) continue;
            return propertyCollection;
        }
        return null;
    }

    public static Property findPropertyByName(List<Property> props, String name) {
        for (Property prop : props) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public static PropertyCollection findPropertyCollection(List<? extends PropertyCollection> propertiesCollection, String name) {
        for (PropertyCollection propertyCollection : propertiesCollection) {
            String currentPropertyCollectionName = PropertiesUtils.extractPropertyCollectionName(propertyCollection.getName());
            String propertyCollectionName = PropertiesUtils.extractPropertyCollectionName(name);
            if (propertyCollectionName == null || currentPropertyCollectionName == null || !propertyCollectionName.equals(currentPropertyCollectionName)) continue;
            return propertyCollection;
        }
        return null;
    }

    private static String extractPropertyCollectionName(String completeName) {
        String[] name = StringUtils.split((String)completeName, (char)';');
        if (name != null && name.length > 0) {
            return name[0];
        }
        return null;
    }

    public static PropertyCollection removeAllInternalAttribues(IReadOnlyPropertyCollection collection) {
        PropertyCollection newCollection = new PropertyCollection();
        for (IReadOnlyProperty property : collection.getProperties()) {
            if (PropertiesUtils.isInternalProperty(property.getName())) continue;
            newCollection.addProperty(PropertiesUtils.toWritableProperty(property));
        }
        for (IReadOnlyPropertyCollection propertyCollection : collection.getPropertyCollections()) {
            newCollection.addPropertyCollection(PropertiesUtils.removeAllInternalAttribues(propertyCollection));
        }
        return newCollection;
    }

    public static boolean isInternalProperty(String attributeName) {
        return attributeName.contains(ID_SEPARATOR) || attributeName.startsWith("org.mule.tooling.");
    }

    public static boolean isWellKnownDocAttribute(String attributeName) {
        return attributeName.startsWith(DOC_PREFIX) && !attributeName.equals(DOC_COMPONENT_ID);
    }

    public static String getPropertyValue(IMessageFlowNode node, String name) {
        if (node == null) {
            return null;
        }
        return PropertiesUtils.getPropertyValue(node.getProperties(), name);
    }

    public static String getAuxiliaryPropertyValue(IMessageFlowNode node, String name) {
        if (node == null) {
            return null;
        }
        return PropertiesUtils.getPropertyValue(node.getProperties(), AUXILIARY_META + name);
    }

    public static <PC, P extends IReadOnlyProperty> String getPropertyValue(IPropertyCollectionReadCapability<PC, P> props, String name) {
        if (props == null) {
            return null;
        }
        return PropertiesUtils.getPropertyValue(props.getProperties(), name);
    }

    public static String getPropertyValue(List<? extends IReadOnlyProperty> props, String name) {
        IReadOnlyProperty prop = PropertiesUtils.findPropertyReadOnlyByName(props, name);
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    public static <PC, P extends IReadOnlyProperty> String getPropertyValue(IPropertyCollectionReadCapability<PC, P> props, String name, String defaultValue) {
        IReadOnlyProperty prop = PropertiesUtils.findPropertyByName(props, name);
        if (PropertiesUtils.isEmpty(prop)) {
            return defaultValue;
        }
        return prop.getValue();
    }

    public static boolean isEmpty(IReadOnlyProperty property) {
        return property == null || StringUtils.isEmpty((String)property.getValue());
    }

    public static boolean isEmpty(IReadOnlyPropertyCollection propertyCollection, String propertyName) {
        return PropertiesUtils.isEmpty((IReadOnlyProperty)propertyCollection.getProperty(propertyName));
    }

    public static boolean removePropertyWithName(List<Property> props, String name) {
        boolean found;
        Property propertyToDelete = null;
        for (Property prop : props) {
            if (!prop.getName().equals(name)) continue;
            propertyToDelete = prop;
            break;
        }
        boolean bl = found = propertyToDelete != null;
        if (found) {
            props.remove(propertyToDelete);
        }
        return found;
    }

    public static void removeAll(List<Property> props, String name) {
        while (PropertiesUtils.removePropertyWithName(props, name)) {
        }
    }

    public static void removeAll(PropertyCollection props, String name) {
        if (props != null) {
            PropertiesUtils.removeAll(props.getProperties(), name);
        }
    }

    public static Property createAuxiliary(String name, String value) {
        return PropertiesUtils.create(AUXILIARY_META + name, value);
    }

    public static Property create(String name, String value) {
        Property prop = new Property();
        prop.setName(name);
        prop.setValue(value);
        return prop;
    }

    public static void addProperty(IMessageFlowNode element, String name, String value) {
        PropertiesUtils.addProperty(element, PropertiesUtils.create(name, value));
    }

    public static void addProperty(IMessageFlowNode element, Property property) {
        PropertyCollection properties = new PropertyCollection();
        PropertiesUtils.copyPropertyCollection(element, new ReadOnlyPropertyCollection(properties));
    }

    public static ArrayList<Property> filter(Collection<Property> ps, Filter filter) {
        ArrayList<Property> result = new ArrayList<Property>();
        for (Property p : ps) {
            if (!filter.select(p)) continue;
            result.add(p);
        }
        return result;
    }

    public static boolean isEmptyProperty(IReadOnlyProperty property) {
        return property == null || StringUtils.isEmpty((String)property.getValue()) || property.getValue().equals("null");
    }

    public static PropertyCollection newPropertyCollection(PropertyCollection parent, String type) {
        int index = 0;
        while (parent.getPropertyCollection(PropertiesUtils.createCollectionIdWithSuffix(type, index)) != null) {
            ++index;
        }
        PropertyCollection propertyCollection = new PropertyCollection();
        propertyCollection.setName(PropertiesUtils.createCollectionIdWithSuffix(type, index));
        parent.addPropertyCollection(propertyCollection);
        return propertyCollection;
    }

    public static PropertyCollection newPropertyCollection(PropertyCollection parent, String type, IElementWrapper element) {
        int index = 0;
        while (parent.getPropertyCollection(PropertiesUtils.createCollectionIdWithSuffix(type, index)) != null) {
            ++index;
        }
        PropertyCollection propertyCollection = new PropertyCollection(element);
        propertyCollection.setName(PropertiesUtils.createCollectionIdWithSuffix(type, index));
        parent.addPropertyCollection(propertyCollection);
        return propertyCollection;
    }

    public static ArrayList<Property> excludeEmptyProperties(Collection<Property> properties) {
        return PropertiesUtils.filter(properties, new DefaultFilter());
    }

    public static PropertyCollection excludeEmptyProperties(PropertyCollection orig) {
        PropertyCollection result = new PropertyCollection();
        result.getPropertyCollections().addAll(orig.getPropertyCollections());
        result.getProperties().addAll(PropertiesUtils.excludeEmptyProperties(orig.getProperties()));
        return result;
    }

    public static String findCollectionKey(PropertyCollectionMap map, String prefix) {
        Map<String, PropertyCollectionMap> collections = map.getPropertyCollections();
        Set<String> keySet = collections.keySet();
        for (String key : keySet) {
            if (!key.startsWith(prefix)) continue;
            return key;
        }
        return null;
    }

    public static List<String> findCollectionKeys(PropertyCollectionMap map, String prefix) {
        Map<String, PropertyCollectionMap> collections = map.getPropertyCollections();
        Set<String> keySet = collections.keySet();
        ArrayList<String> keysFound = new ArrayList<String>();
        for (String key : keySet) {
            if (!key.startsWith(prefix)) continue;
            keysFound.add(key);
        }
        return keysFound;
    }

    public static String getPropertyValue(List<IReadOnlyPropertyCollection> propertyCollections, final String name, String defaultValue) {
        IReadOnlyPropertyCollection propertyCollection = (IReadOnlyPropertyCollection)Iterables.find(propertyCollections, (Predicate)new Predicate<IReadOnlyPropertyCollection>(){

            public boolean apply(IReadOnlyPropertyCollection propertyCollection) {
                return propertyCollection.getProperty(name) != null;
            }
        }, null);
        if (propertyCollection == null) {
            return defaultValue;
        }
        return ((IReadOnlyProperty)propertyCollection.getProperty(name)).getValue();
    }

    public static PropertyCollection copyOf(IReadOnlyPropertyCollection propertyCollection, final List<String> propertyNames) {
        ArrayList properties = Lists.newArrayList((Iterable)Collections2.filter(propertyCollection.getProperties(), (Predicate)new Predicate<IReadOnlyProperty>(){

            public boolean apply(IReadOnlyProperty property) {
                if (propertyNames != null && !propertyNames.isEmpty()) {
                    return !propertyNames.contains(property.getName());
                }
                return true;
            }
        }));
        PropertyCollection result = new PropertyCollection();
        for (IReadOnlyProperty readOnlyProperty : properties) {
            result.getProperties().add(PropertiesUtils.toWritableProperty(readOnlyProperty));
        }
        return result;
    }

    public static Iterable<PropertyCollection> getPropertiesCollectionsWithType(PropertyCollection propertyCollection, final String definitionId) {
        return Iterables.filter(propertyCollection.getPropertyCollections(), (Predicate)new Predicate<PropertyCollection>(){

            public boolean apply(PropertyCollection input) {
                return input.getName().startsWith(PropertiesUtils.ID_PREFIX + definitionId);
            }
        });
    }

    public static IReadOnlyPropertyCollection getFirstNestedElementProperty(IMessageFlowNode messageFlowNode, String nestedElementId) {
        if (messageFlowNode.getProperties() == null) {
            return null;
        }
        List propertyCollections = messageFlowNode.getProperties().getPropertyCollections();
        for (IReadOnlyPropertyCollection propertyCollection : propertyCollections) {
            if (!propertyCollection.getName().contains(nestedElementId + ID_SEPARATOR)) continue;
            return propertyCollection;
        }
        return null;
    }

    public static List<IReadOnlyPropertyCollection> getNestedElementProperties(IMessageFlowNode messageFlowNode, String ... nestedElementIds) {
        List propertyCollections = messageFlowNode.getProperties().getPropertyCollections();
        ArrayList<IReadOnlyPropertyCollection> propertyCollectionsToReturn = new ArrayList<IReadOnlyPropertyCollection>();
        for (IReadOnlyPropertyCollection propertyCollection : propertyCollections) {
            String[] stringArray = nestedElementIds;
            int n = nestedElementIds.length;
            int n2 = 0;
            while (n2 < n) {
                String nestedElementId = stringArray[n2];
                if (propertyCollection.getName().contains(nestedElementId + ID_SEPARATOR)) {
                    propertyCollectionsToReturn.add(propertyCollection);
                }
                ++n2;
            }
        }
        return propertyCollectionsToReturn;
    }

    public static <PC extends IPropertyCollectionReadCapability<PC, P>, P extends IReadOnlyProperty> PropertyCollection toWritablePropertyCollection(IPropertyCollectionReadCapability<PC, P> readOnlyPropertyCollection) {
        PropertyCollection propertyCollection = new PropertyCollection(readOnlyPropertyCollection.getElement());
        propertyCollection.setName(readOnlyPropertyCollection.getName());
        propertyCollection.setErased(readOnlyPropertyCollection.isErased());
        List<P> readOnlyProperties = readOnlyPropertyCollection.getProperties();
        List<PC> readOnlyPropertiesCollectionInner = readOnlyPropertyCollection.getPropertyCollections();
        for (IReadOnlyProperty readOnlyProperty : readOnlyProperties) {
            propertyCollection.addProperty(PropertiesUtils.toWritableProperty(readOnlyProperty));
        }
        for (IPropertyCollectionReadCapability readOnlyPropertyCollectionInner : readOnlyPropertiesCollectionInner) {
            propertyCollection.addPropertyCollection(PropertiesUtils.toWritablePropertyCollection(readOnlyPropertyCollectionInner));
        }
        return propertyCollection;
    }

    public static <PC extends IPropertyCollectionReadCapability, P extends IReadOnlyProperty> void copyPropertyCollection(IMessageFlowNode targetNode, IPropertyCollectionReadCapability<PC, P> propertiesToCopy) {
        PropertyCollection targetNodePropertyCollection = targetNode.getPropertiesForEdit(null);
        for (IReadOnlyProperty readOnlyProperty : propertiesToCopy.getProperties()) {
            targetNodePropertyCollection.addProperty(PropertiesUtils.toWritableProperty(readOnlyProperty));
        }
        for (IPropertyCollectionReadCapability readOnlyPropertyCollection : propertiesToCopy.getPropertyCollections()) {
            targetNodePropertyCollection.addPropertyCollection(PropertiesUtils.toWritablePropertyCollection(readOnlyPropertyCollection));
        }
    }

    public static PropertyCollection hasPropertyCollectionInCommon(List<IReadOnlyPropertyCollection> readOropertyCollection, List<PropertyCollection> propertyCollection) {
        int i = 0;
        while (i < readOropertyCollection.size()) {
            for (IReadOnlyPropertyCollection property : readOropertyCollection.get(i).getPropertyCollections()) {
                PropertyCollection propertyFound;
                PropertyCollection currentPropertyCollection;
                if (i >= propertyCollection.size() || (currentPropertyCollection = propertyCollection.get(i)) == null || (propertyFound = PropertiesUtils.findPropertyCollection(currentPropertyCollection.getPropertyCollections(), property.getName())) == null) continue;
                return propertyFound;
            }
            ++i;
        }
        return null;
    }

    public static PropertyCollection from(PropertyCollection source, IElementWrapper element) {
        PropertyCollection pc = new PropertyCollection(element);
        pc.setName(source.getName());
        pc.setErased(source.isErased());
        for (Property innerProperty : source.getProperties()) {
            pc.addProperty(innerProperty);
        }
        for (PropertyCollection innerPropertyCollection : source.getPropertyCollections()) {
            pc.addPropertyCollection(innerPropertyCollection);
        }
        return pc;
    }

    public static void copyPropertyCollectionMap(PropertyCollectionMap prop, PropertyCollectionMap other) {
        other.getPropertiesMap().asPropertyList().forEach(property -> prop.addProperty((Property)property));
        other.getPropertyCollections().forEach((name, propertyCollection) -> prop.addPropertyCollection((String)name, (PropertyCollectionMap)propertyCollection));
    }

    public static Property toWritableProperty(IReadOnlyProperty property) {
        return new Property(property.getName(), property.getValue());
    }

    public static Optional<IReadOnlyPropertyCollection> findPropertyCollectionWithNamePrefix(IReadOnlyPropertyCollection propertyCollection, String namePrefix) {
        Optional<IReadOnlyPropertyCollection> wrapperCollection = Optional.empty();
        String name = propertyCollection.getName();
        if (name != null && name.startsWith(namePrefix)) {
            wrapperCollection = Optional.of(propertyCollection);
        } else {
            List propertyCollections = propertyCollection.getPropertyCollections();
            for (IReadOnlyPropertyCollection property : propertyCollections) {
                wrapperCollection = PropertiesUtils.findPropertyCollectionWithNamePrefix(property, namePrefix);
                if (wrapperCollection.isPresent()) break;
            }
        }
        return wrapperCollection;
    }

    public static String createTailCollectionId(String id) {
        return PropertiesUtils.createCollectionIdWithSuffix(id, Long.MAX_VALUE);
    }

    public static String createNewCollectionId(String id) {
        return PropertiesUtils.createCollectionIdWithSuffix(id, 0L);
    }

    public static String createCollectionIdWithSuffix(String id, long suffix) {
        return PropertiesUtils.createCollectionId(id) + suffix;
    }

    public static String createCollectionIdWithSuffix(String id, String suffix) {
        return PropertiesUtils.createCollectionId(id) + suffix;
    }

    public static String createCollectionId(String id) {
        return ID_PREFIX + id + ID_SEPARATOR;
    }

    public static String getNodeDefinitionId(String propertyCollectionKey) {
        Matcher matcher = PROPERTY_COLLECTION_KEY_PATTERN.matcher(propertyCollectionKey);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return propertyCollectionKey;
    }

    public static boolean isChildElement(String xmlName, PropertyCollectionMap properties) {
        return properties.getPropertyCollections().entrySet().stream().anyMatch(entry -> ((String)entry.getKey()).contains(xmlName));
    }

    public static PropertyCollection getEffectivePropertyCollection(PropertyCollection propertyCollection) {
        PropertyCollection effectivePC = new PropertyCollection();
        effectivePC.setName(propertyCollection.getName());
        effectivePC.setElement(propertyCollection.getElement());
        List regularProperties = propertyCollection.getProperties().stream().filter(p -> !p.getName().startsWith(AUXILIARY_PREFIX)).collect(Collectors.toList());
        List deletedProperties = propertyCollection.getProperties().stream().filter(p -> p.getName().startsWith(AUXILIARY_ERASED)).collect(Collectors.toList());
        List<Property> effectiveAttributes = regularProperties.stream().filter(p -> {
            String erasedName = AUXILIARY_ERASED + p.getName();
            return deletedProperties.stream().noneMatch(x -> erasedName.equals(x.getName()));
        }).collect(Collectors.toList());
        effectiveAttributes = PropertiesUtils.removeExchangePatternProperties(effectiveAttributes);
        effectiveAttributes.stream().map(x -> {
            if (StringUtils.isEmpty((String)x.getValue())) {
                return new Property(x.getName(), null);
            }
            return x;
        }).forEach(effectivePC::addProperty);
        propertyCollection.getPropertyCollections().stream().forEach(collection -> {
            if (!collection.isErased()) {
                PropertyCollection effectivePropertyCollection = PropertiesUtils.getEffectivePropertyCollection(collection);
                effectivePC.addPropertyCollection(effectivePropertyCollection);
            }
        });
        return effectivePC;
    }

    public static List<Property> removeExchangePatternProperties(List<Property> effectiveAttributes) {
        return effectiveAttributes.stream().filter(p -> !p.getName().equals(EXCHANGE_PATTERN)).collect(Collectors.toList());
    }

    private static final class DefaultFilter
    implements Filter {
        private DefaultFilter() {
        }

        @Override
        public boolean select(Property p) {
            return p != null && p.getValue() != null;
        }
    }

    public static interface Filter {
        public boolean select(Property var1);
    }
}

