/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow.util;

import java.util.HashSet;
import java.util.Set;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.util.NamingUtils;

public class MuleConfigurationNamingSupport {
    private Set<String> usedNames = new HashSet<String>();

    public MuleConfigurationNamingSupport(MuleConfiguration config) {
        for (IMessageFlowEntity element : config.getGlobalEntries()) {
            IMessageFlowEntity entity = element;
            if (!(entity instanceof MessageFlowNode)) continue;
            this.usedNames.add(((MessageFlowNode)entity).getName());
        }
        for (Container flow : config.getFlows()) {
            this.processNode(flow);
        }
    }

    public String getAvailableName(String prefix) {
        return NamingUtils.getAvailableName(prefix, this.usedNames);
    }

    protected void processNode(MessageFlowNode node) {
        this.usedNames.add(node.getName());
        if (node instanceof Container) {
            for (CompartmentLane lane : ((Container)node).getLanes()) {
                for (IMessageFlowEntity entry : lane.getCompartmentLaneEntries()) {
                    IMessageFlowEntity entity = entry;
                    if (!(entity instanceof MessageFlowNode)) continue;
                    this.processNode((MessageFlowNode)entity);
                }
            }
        }
    }

    public Set<String> getUsedNames() {
        return this.usedNames;
    }
}

