/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.util.IMessageProcessorNode;

public abstract class AbstractMessageProcessorNode<T extends MessageFlowEntity>
implements IMessageProcessorNode<T> {
    protected IMessageProcessorNode<?> parent;
    protected List<IMessageProcessorNode<? extends MessageFlowEntity>> children;
    protected T value;

    public AbstractMessageProcessorNode(T value) {
        this.value = value;
        this.children = new ArrayList<IMessageProcessorNode<? extends MessageFlowEntity>>();
    }

    void setParent(IMessageProcessorNode<?> parent) {
        this.parent = parent;
    }

    @Override
    public IMessageProcessorNode<? extends MessageFlowEntity> getParent() {
        return this.parent;
    }

    @Override
    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    @Override
    public List<IMessageProcessorNode<?>> getChildren() {
        return this.children;
    }

    @Override
    public IMessageProcessorNode<MuleConfiguration> getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    @Override
    public void addChild(IMessageProcessorNode<?> child) {
        if (child.getParent() != null) {
            throw new IllegalStateException("Child element already has a parent");
        }
        this.children.add(child);
        ((AbstractMessageProcessorNode)child).setParent(this);
    }

    @Override
    public int getPosition() {
        return this.getParent() != null ? this.getChildrenWithoutComments().indexOf(this) : -1;
    }

    private List<IMessageProcessorNode<?>> getChildrenWithoutComments() {
        return this.getParent().getChildren().stream().filter(child -> !ModelUtils.isComment(child.getValue())).collect(Collectors.toList());
    }

    @Override
    public boolean traverse(IMessageProcessorNode.Predicate predicate) {
        boolean accept = predicate.accept(this);
        if (accept) {
            for (IMessageProcessorNode<?> child : this.getChildren()) {
                accept = child.traverse(predicate);
                if (!accept) break;
            }
        }
        return accept;
    }

    @Override
    public IMessageProcessorNode<?> getFirstChild() {
        return this.getChildren().isEmpty() ? null : this.getChildren().get(0);
    }

    @Override
    public IMessageProcessorNode<?> getLastChild() {
        return this.getChildren().isEmpty() ? null : this.getChildren().get(this.getChildren().size() - 1);
    }

    @Override
    public IMessageProcessorNode<?> getPrevious() {
        if (this.parent != null) {
            return ((AbstractMessageProcessorNode)this.parent).getPreviousOf(this);
        }
        return null;
    }

    abstract IMessageProcessorNode<?> getNextOf(IMessageProcessorNode<?> var1);

    abstract IMessageProcessorNode<?> getPreviousOf(IMessageProcessorNode<?> var1);

    @Override
    public IMessageProcessorNode<?> getNext() {
        if (this.parent != null) {
            return ((AbstractMessageProcessorNode)this.parent).getNextOf(this);
        }
        return null;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMessageProcessorNode other = (AbstractMessageProcessorNode)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value.toString();
    }
}

