/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow.util;

import java.util.List;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;

public abstract class AbstractMessageFlowEntityVisitor
implements MessageFlowEntityVisitor {
    @Override
    public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
        if (!this.preMuleConfiguration(muleConfiguration)) {
            this.preChildrenVisit(muleConfiguration);
        }
        for (Container flow : muleConfiguration.getFlows()) {
            flow.accept(this);
        }
        for (IMessageFlowEntity globalEntry : muleConfiguration.getGlobalEntries()) {
            globalEntry.accept(this);
        }
        if (!this.postMuleConfiguration(muleConfiguration)) {
            this.postChildrenVisit(muleConfiguration);
        }
    }

    public boolean preMuleConfiguration(MuleConfiguration muleConfiguration) {
        return false;
    }

    public boolean postMuleConfiguration(MuleConfiguration muleConfiguration) {
        return false;
    }

    @Override
    public void visitGlobalElement(GlobalElement globalElement) {
        if (!this.preGlobalElement(globalElement)) {
            this.preChildrenVisit(globalElement);
        }
        if (!this.postGlobalElement(globalElement)) {
            this.postChildrenVisit(globalElement);
        }
    }

    public boolean preGlobalElement(GlobalElement globalElement) {
        return false;
    }

    public boolean postGlobalElement(GlobalElement globalElement) {
        return false;
    }

    @Override
    public void visitContainer(Container container) {
        if (!this.preContainer(container)) {
            this.preChildrenVisit(container);
        }
        for (CompartmentLane lane : container.getLanes()) {
            lane.accept(this);
        }
        if (!this.postContainer(container)) {
            this.postChildrenVisit(container);
        }
    }

    public boolean preContainer(Container flow) {
        return false;
    }

    public boolean postContainer(Container flow) {
        return false;
    }

    @Override
    public void visitCompartment(Compartment compartment) {
        List<CompartmentLane> lanes = compartment.getLanes();
        if (!this.preCompartment(compartment)) {
            this.preChildrenVisit(compartment);
        }
        for (CompartmentLane compartmentLane : lanes) {
            compartmentLane.accept(this);
        }
        if (!this.postCompartment(compartment)) {
            this.postChildrenVisit(compartment);
        }
    }

    public boolean preCompartment(Compartment compartment) {
        return false;
    }

    public boolean postCompartment(Compartment compartment) {
        return false;
    }

    @Override
    public void visitCompartmentLane(CompartmentLane lane) {
        if (!this.preCompartmentLane(lane)) {
            this.preChildrenVisit(lane);
        }
        for (IMessageFlowEntity entity : lane.getCompartmentLaneEntries()) {
            entity.accept(this);
        }
        if (!this.postCompartmentLane(lane)) {
            this.postChildrenVisit(lane);
        }
    }

    @Override
    public void visitRoute(Route route) {
        this.visitCompartmentLane(route);
    }

    @Override
    public void visitNestedContainer(NestedContainer nestedContainer) {
        if (!this.preCompartmentLane(nestedContainer)) {
            this.preChildrenVisit(nestedContainer);
        }
        for (IMessageFlowEntity entity : nestedContainer.getCompartmentLaneEntries()) {
            entity.accept(this);
        }
        if (!this.postCompartmentLane(nestedContainer)) {
            this.postChildrenVisit(nestedContainer);
        }
    }

    public boolean preCompartmentLane(CompartmentLane lane) {
        return false;
    }

    public boolean postCompartmentLane(CompartmentLane lane) {
        return false;
    }

    @Override
    public void visitSplitterNode(SplitterNode splitterNode) {
        Compartment compartment = splitterNode.getCompartment();
        if (!this.preSplitterNode(splitterNode)) {
            this.preChildrenVisit(splitterNode);
        }
        if (compartment != null) {
            compartment.accept(this);
        }
        if (!this.postSplitterNode(splitterNode)) {
            this.postChildrenVisit(splitterNode);
        }
    }

    public boolean preSplitterNode(SplitterNode splitterNode) {
        return false;
    }

    public boolean postSplitterNode(SplitterNode splitterNode) {
        return false;
    }

    public abstract void preChildrenVisit(MessageFlowEntity var1);

    public abstract void postChildrenVisit(MessageFlowEntity var1);
}

