/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow.path;

import com.google.common.collect.HashBiMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.IMulePathsCalculator;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.utils.LazyValue;

public class MulePathsCache {
    private boolean isValid;
    private HashBiMap<MessageFlowEntity, MulePath> paths;
    private final MuleConfiguration config;
    private LazyValue<IMulePathsCalculator> calculator;

    public MulePathsCache(MuleConfiguration config) {
        this.config = config;
        this.calculator = new LazyValue(() -> this.getPathsCalculator());
    }

    private void calculateIfNecessary(IMuleProject project) {
        if (!this.isValid) {
            this.paths = ((IMulePathsCalculator)this.calculator.getOrCompute()).findMulePathsForMuleConfiguration(this.config, project);
            this.isValid = true;
        }
    }

    public MulePath getPath(IMessageFlowEntity entity, IMuleProject project) {
        this.calculateIfNecessary(project);
        return (MulePath)this.paths.get((Object)entity);
    }

    public MessageFlowEntity getEntity(MulePath path, IMuleProject project) {
        this.calculateIfNecessary(project);
        return (MessageFlowEntity)this.paths.inverse().get((Object)path);
    }

    public void invalidate() {
        this.isValid = false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private IMulePathsCalculator getPathsCalculator() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.core.mulePathsCalculator");
        if (configElements.length != 0) {
            IConfigurationElement configElement = iConfigurationElementArray[0];
            try {
                IMulePathsCalculator clazz = (IMulePathsCalculator)configElement.createExecutableExtension("class");
                return clazz;
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("no paths calculator found");
    }

    public boolean containsPath(MulePath mulePath) {
        return this.paths.inverse().containsKey((Object)mulePath);
    }
}

