/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow.path;

public class MulePathNode {
    public static final String EXCEPTION_STRATEGY_MARKER = "errorHandler";
    public static final String PROCESSES_MARKER = "processors";
    public static final String SUBPROCESSES_MARKER = "subprocessors";
    public static final String SOURCE_MARKER = "source";
    public static final String ROUTE_MARKER = "route";
    private String flowName;
    private String nodeName;

    public MulePathNode(String flowName, String elementName) {
        this.flowName = flowName;
        this.nodeName = elementName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public String getMarker() {
        return this.nodeName;
    }

    public int getIndex() {
        return Integer.parseInt(this.nodeName);
    }

    public boolean isIndexNode() {
        try {
            Integer.parseInt(this.nodeName);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean isMarkerNode() {
        return !this.isIndexNode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MulePathNode that = (MulePathNode)o;
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        return !(this.flowName != null ? !this.flowName.equals(that.flowName) : that.flowName != null);
    }

    public int hashCode() {
        int result = this.flowName != null ? this.flowName.hashCode() : 0;
        result = 31 * result + (this.nodeName != null ? this.nodeName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MulePathNode [flowName=" + this.flowName + ", nodeName=" + this.nodeName + "]";
    }
}

