/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow.path;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.mule.tooling.model.messageflow.path.MulePathNode;
import org.mule.tooling.model.messageflow.path.MulePathTokenizer;

public class MulePath {
    private String flowName;
    private List<MulePathNode> nodes;

    public MulePath(String flowName) {
        this(flowName, new ArrayList<MulePathNode>());
    }

    private MulePath(String flowName, List<MulePathNode> nodes) {
        this.flowName = flowName == null ? "" : flowName;
        this.nodes = nodes;
    }

    public void addNode(MulePathNode element) {
        this.nodes.add(element);
    }

    public List<MulePathNode> getNodes() {
        return this.nodes;
    }

    public MulePathNode getLastNode() {
        return this.getNodes().isEmpty() ? null : this.getNodes().get(this.getNodes().size() - 1);
    }

    public MulePathNode getFirstNode() {
        return this.getNodes().isEmpty() ? null : this.getNodes().get(0);
    }

    public MulePath createChild(int value) {
        return this.createChild(String.valueOf(value));
    }

    public MulePath createChild(String value) {
        ArrayList<MulePathNode> childNodes = new ArrayList<MulePathNode>(this.nodes);
        childNodes.add(new MulePathNode(this.getFlowName(), value));
        return new MulePath(this.getFlowName(), childNodes);
    }

    public MulePath getParent() {
        return new MulePath(this.getFlowName(), this.nodes.subList(0, this.nodes.size() - 1));
    }

    public String getFlowName() {
        return this.flowName;
    }

    public boolean hasParent() {
        return !this.nodes.isEmpty();
    }

    public static String escape(String name) {
        StringBuilder builder = new StringBuilder(name.length() * 2);
        int previous = 32;
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            int c = cArray[n2];
            builder.append(c == 47 && previous != 92 ? "\\/" : Character.valueOf((char)c));
            previous = c;
            ++n2;
        }
        return builder.toString();
    }

    public String toPath() {
        StringBuilder basePath = new StringBuilder();
        basePath.append(MulePath.escape(this.getFlowName()));
        for (MulePathNode node : this.nodes) {
            basePath.append("/");
            basePath.append(MulePath.escape(node.getMarker()));
        }
        return basePath.toString();
    }

    public String toString() {
        return this.toPath();
    }

    public static MulePath fromPath(String path) {
        MulePath result;
        Iterator<String> tokens = new MulePathTokenizer().tokenList(path).iterator();
        if (tokens.hasNext()) {
            ArrayList<MulePathNode> elements = new ArrayList<MulePathNode>();
            String flowName = tokens.next();
            while (tokens.hasNext()) {
                elements.add(new MulePathNode(flowName, tokens.next()));
            }
            result = new MulePath(flowName, elements);
        } else {
            result = MulePath.emptyPath();
        }
        return result;
    }

    private static MulePath emptyPath() {
        return new MulePath(null, new ArrayList<MulePathNode>());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MulePath that = (MulePath)o;
        if (this.flowName != null ? !this.flowName.equals(that.flowName) : that.flowName != null) {
            return false;
        }
        if (this.nodes == null || that.nodes == null) {
            return this.nodes == that.nodes;
        }
        return CollectionUtils.isEqualCollection(this.nodes, that.nodes);
    }

    public int hashCode() {
        int result = this.nodes != null ? this.nodes.hashCode() : 0;
        result = 31 * result + (this.flowName != null ? this.flowName.hashCode() : 0);
        return result;
    }
}

