/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow.decorator;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertiesMap;

public class PropertyCollectionMap {
    private String name;
    private boolean erased;
    private IElementWrapper element;
    private PropertiesMap propMap = new PropertiesMap();
    private Map<String, PropertyCollectionMap> childElementCollsMap = new LinkedHashMap<String, PropertyCollectionMap>();

    public String getName() {
        return this.name;
    }

    public PropertyCollectionMap() {
        this(null, null);
    }

    public PropertyCollectionMap(PropertyCollection top) {
        this(top.getElement(), top);
    }

    public PropertyCollectionMap(IElementWrapper element) {
        this(element, null);
    }

    public PropertyCollectionMap(IElementWrapper element, PropertyCollection top) {
        this.element = element;
        if (top != null) {
            this.name = top.getName();
            this.setErased(top.isErased());
            this.propMap = new PropertiesMap(top.getProperties());
            for (PropertyCollection coll : top.getPropertyCollections()) {
                PropertyCollectionMap current = new PropertyCollectionMap(coll);
                this.childElementCollsMap.put(coll.getName(), current);
            }
        }
    }

    public PropertyCollectionMap(IReadOnlyPropertyCollection properties) {
        this.name = properties.getName();
        this.erased = properties.isErased();
        this.element = properties.getElement();
        this.propMap = new PropertiesMap(properties.getProperties());
        for (IReadOnlyPropertyCollection coll : properties.getPropertyCollections()) {
            PropertyCollectionMap current = new PropertyCollectionMap(coll);
            this.childElementCollsMap.put(coll.getName(), current);
        }
    }

    public boolean isErased() {
        return this.erased;
    }

    public void setErased(boolean erased) {
        this.erased = erased;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addPropertyCollection(String name, PropertyCollectionMap subMap) {
        this.childElementCollsMap.put(name, subMap);
    }

    public PropertyCollectionMap removePropertyCollection(String name) {
        return this.childElementCollsMap.remove(name);
    }

    public List<String> getPropertyCollectionNames(Predicate predicate) {
        ArrayList<String> names = new ArrayList<String>();
        Set<String> collectionNames = this.childElementCollsMap.keySet();
        for (String collectionName : collectionNames) {
            if (!predicate.evaluate((Object)collectionName)) continue;
            names.add(collectionName);
        }
        return names;
    }

    public void addProperty(String name, String value) {
        this.propMap.addProperty(name, value);
    }

    public void addProperty(Property property) {
        this.addProperty(property.getName(), property.getValue());
    }

    public boolean hasProperty(String name) {
        return this.getPropertiesMap().hasProperty(name);
    }

    public String removeProperty(String name) {
        return this.getPropertiesMap().removeProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        return this.getPropertiesMap().getProperty(name, defaultValue);
    }

    public Optional<String> getPropertyOpt(String name) {
        return Optional.fromNullable((Object)this.getPropertiesMap().getProperty(name, null));
    }

    public int getIntProperty(String name, int defaultValue) {
        return this.getPropertiesMap().getIntProperty(name, defaultValue);
    }

    public long getLongProperty(String name, long defaultValue) {
        return this.getPropertiesMap().getLongProperty(name, defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return this.getPropertiesMap().getBooleanProperty(name, defaultValue);
    }

    public PropertyCollectionMap getPropertyCollectionMap(String name) {
        return this.childElementCollsMap.get(name);
    }

    public PropertiesMap getPropertiesMap() {
        return this.propMap;
    }

    public PropertyCollection asPropertyCollection() {
        PropertyCollection result = new PropertyCollection(this.element);
        result.setName(this.name);
        result.setErased(this.isErased());
        result.getProperties().addAll(this.propMap.asPropertyList());
        Set<Map.Entry<String, PropertyCollectionMap>> entrySet = this.childElementCollsMap.entrySet();
        for (Map.Entry<String, PropertyCollectionMap> entry : entrySet) {
            PropertyCollection childProperties = entry.getValue().asPropertyCollection();
            childProperties.setName(entry.getKey());
            result.addPropertyCollection(childProperties);
        }
        return result;
    }

    public Map<String, PropertyCollectionMap> getPropertyCollections() {
        return this.childElementCollsMap;
    }

    public String toString() {
        return this.getName() + this.childElementCollsMap.toString() + ", " + this.propMap.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.childElementCollsMap == null ? 0 : this.childElementCollsMap.hashCode());
        result = 31 * result + (this.propMap == null ? 0 : this.propMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyCollectionMap other = (PropertyCollectionMap)obj;
        if (this.childElementCollsMap == null ? other.childElementCollsMap != null : !this.childElementCollsMap.equals(other.childElementCollsMap)) {
            return false;
        }
        return !(this.propMap == null ? other.propMap != null : !this.propMap.equals(other.propMap));
    }

    public boolean isEmpty() {
        return this.childElementCollsMap.isEmpty() && this.propMap.isEmpty();
    }

    public void removePropertyCollectionMap(String name) {
        this.childElementCollsMap.remove(name);
    }

    public void erasedPropertyCollectionMap(String name) {
        this.childElementCollsMap.get(name).setErased(true);
    }

    public List<String> getPropertyCollectionNamesWithPrefix(String prefix) {
        ArrayList<String> names = new ArrayList<String>();
        Set<String> collectionNames = this.childElementCollsMap.keySet();
        for (String collectionName : collectionNames) {
            if (!collectionName.startsWith(prefix)) continue;
            names.add(collectionName);
        }
        return names;
    }

    public void replaceChildElementsMap(Map<String, PropertyCollectionMap> map) {
        this.childElementCollsMap = map;
    }

    public List<PropertyCollectionMap> getPropertyCollectionsWithPrefix(String prefix) {
        Map<String, PropertyCollectionMap> collections = this.getPropertyCollections();
        Set<String> keySet = this.getPropertyCollections().keySet();
        ArrayList<PropertyCollectionMap> collectionsFound = new ArrayList<PropertyCollectionMap>();
        for (String key : keySet) {
            if (!key.startsWith(prefix)) continue;
            collectionsFound.add(collections.get(key));
        }
        return collectionsFound;
    }
}

