/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow.decorator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.Property;

public class PropertiesMap {
    private Map<String, String> propMap = new HashMap<String, String>();

    public PropertiesMap() {
    }

    public PropertiesMap(List<? extends IReadOnlyProperty> properties) {
        if (properties != null) {
            for (IReadOnlyProperty iReadOnlyProperty : properties) {
                this.propMap.put(iReadOnlyProperty.getName(), iReadOnlyProperty.getValue());
            }
        }
    }

    public String getProperty(String name, String defaultValue) {
        String result = this.propMap.get(name);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public boolean hasProperty(String name) {
        return this.propMap.keySet().contains(name);
    }

    public String removeProperty(String name) {
        return this.propMap.remove(name);
    }

    public int getIntProperty(String name, int defaultValue) {
        String value = this.getProperty(name, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public long getLongProperty(String name, long defaultValue) {
        String value = this.getProperty(name, null);
        if (value != null) {
            try {
                return Long.parseLong(name);
            }
            catch (NumberFormatException numberFormatException) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String value = this.getProperty(name, null);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.propMap == null ? 0 : this.propMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertiesMap other = (PropertiesMap)obj;
        return !(this.propMap == null ? other.propMap != null : !this.propMap.equals(other.propMap));
    }

    public void addProperty(String name, String value) {
        if (value == null) {
            this.propMap.remove(name);
        } else {
            this.propMap.put(name, value);
        }
    }

    public List<Property> asPropertyList() {
        ArrayList<Property> result = new ArrayList<Property>();
        Set<String> keys = this.propMap.keySet();
        for (String name : keys) {
            Property prop = new Property();
            prop.setName(name);
            prop.setValue(this.propMap.get(name));
            result.add(prop);
        }
        return result;
    }

    public String toString() {
        return this.propMap.toString();
    }

    public boolean isEmpty() {
        return this.propMap.isEmpty();
    }

    public Set<String> keySet() {
        return this.propMap.keySet();
    }
}

