/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow.decorator;

import java.util.List;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.ContainerOfMovableEntities;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.IGlobalDecorator;
import org.mule.tooling.model.messageflow.util.MuleConfigurationNamingSupport;

public class MuleConfigurationDecorator
extends EntityDecorator<MuleConfiguration>
implements ContainerOfMovableEntities {
    public static final String PROP_FLOWS = "flows";
    public static final String PROP_GLOBALS = "globals";

    public MuleConfigurationDecorator(MuleConfiguration entity) {
        super(entity);
    }

    public void addFlow(Container flow) {
        ((MuleConfiguration)this.getEntity()).getFlows().add(flow);
        ((MuleConfiguration)this.getEntity()).getDocument().getRootElement().add(flow.getElement());
        this.fireEvent(PROP_FLOWS);
    }

    public int getFlowIndex(Container element) {
        return ((MuleConfiguration)this.getEntity()).getFlows().indexOf(element);
    }

    public void removeFlow(Container flow) {
        ((MuleConfiguration)this.getEntity()).getFlows().remove(flow);
        ((MuleConfiguration)this.getEntity()).getDocument().getRootElement().removeChild(flow.getElement());
        this.fireEvent(PROP_FLOWS);
    }

    public List<Container> getFlows() {
        return ((MuleConfiguration)this.getEntity()).getFlows();
    }

    public void addGlobal(GlobalElement element) {
        this.addGlobal(element, true);
    }

    private void addGlobal(IMessageFlowEntity messageFlowEntity, boolean fireEvent) {
        IMessageFlowEntity entity = messageFlowEntity;
        ((MuleConfiguration)this.getEntity()).getGlobalEntries().add(entity);
        if (messageFlowEntity instanceof GlobalElement) {
            IGlobalDecorator globalWrapper = (IGlobalDecorator)((Object)MessageFlowFactory.getWrappedEntity(messageFlowEntity));
            globalWrapper.addElementToConfiguration(this);
        } else {
            ((MuleConfiguration)this.getEntity()).getElement().add(entity.getElement());
        }
        if (fireEvent) {
            this.fireEvent(PROP_GLOBALS);
        }
    }

    public void addGlobalUnknown(GlobalUnknown element) {
        GlobalUnknown entity = element;
        ((MuleConfiguration)this.getEntity()).getGlobalEntries().add(entity);
        this.fireEvent(PROP_GLOBALS);
    }

    public void removeGlobal(IMessageFlowEntity element) {
        this.removeGlobal(element, true);
    }

    private void removeGlobal(IMessageFlowEntity entity, boolean fireEvent) {
        IMessageFlowEntity toDelete = null;
        for (IMessageFlowEntity current : ((MuleConfiguration)this.getEntity()).getGlobalEntries()) {
            if (!current.equals(entity)) continue;
            toDelete = current;
        }
        if (toDelete != null) {
            ((MuleConfiguration)this.getEntity()).getGlobalEntries().remove(toDelete);
            IGlobalDecorator globalDecorator = (IGlobalDecorator)((Object)MessageFlowFactory.getWrappedEntity(toDelete));
            globalDecorator.removeElementFromConfiguration(this);
            if (fireEvent) {
                this.fireEvent(PROP_GLOBALS);
            }
        }
    }

    @Override
    public void addEntity(int index, IMessageFlowEntity messageFlowEntity, boolean fireEvent) {
        if (!(messageFlowEntity instanceof Container)) {
            this.addGlobal(messageFlowEntity, fireEvent);
        } else {
            this.addFlow(index, (Container)messageFlowEntity, fireEvent);
        }
        IElementWrapper element = messageFlowEntity.getElement();
        ((MuleConfiguration)this.getEntity()).getDocument().getRootElement().add(index + ((MuleConfiguration)this.getEntity()).getGlobalEntries().size(), element);
    }

    private void addFlow(int index, Container messageFlowEntity, boolean fireEvent) {
        ((MuleConfiguration)this.getEntity()).getFlows().add(index, messageFlowEntity);
        if (fireEvent) {
            this.fireEvent(PROP_FLOWS);
        }
    }

    @Override
    public void moveMessageFlowEntityTo(IMessageFlowEntity entity, ContainerOfMovableEntities target, int targetIndex, boolean hasLastEntityToMove) {
        this.removeEntity(entity, false);
        target.addEntity(targetIndex, entity, false);
        this.fireEvent(PROP_FLOWS);
        ((EntityDecorator)((Object)target)).fireEvent("entities");
    }

    @Override
    public int findEntityIndex(IMessageFlowEntity entity) {
        if (entity == null) {
            return -1;
        }
        int index = 0;
        for (Container current : ((MuleConfiguration)this.getEntity()).getFlows()) {
            if (current.equals(entity)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public void addEntity(int index, IMessageFlowEntity messageFlowEntity) {
        this.addEntity(index, messageFlowEntity, true);
    }

    @Override
    public void removeEntity(IMessageFlowEntity entity, boolean fireEvent) {
        if (!(entity instanceof Container)) {
            this.removeGlobal(entity, fireEvent);
        } else {
            this.removeFlow((Container)entity, fireEvent);
        }
    }

    private void removeFlow(Container messageFlowEntity, boolean fireEvent) {
        Container toDelete = null;
        for (Container current : ((MuleConfiguration)this.getEntity()).getFlows()) {
            if (!current.equals(messageFlowEntity)) continue;
            toDelete = current;
        }
        if (toDelete != null) {
            ((MuleConfiguration)this.getEntity()).getFlows().remove(toDelete);
            ((MuleConfiguration)this.getEntity()).getDocument().getRootElement().removeChild(toDelete.getElement());
            if (fireEvent) {
                this.fireEvent(PROP_FLOWS);
            }
        }
    }

    @Override
    public IMessageFlowEntity getLastEntity() {
        if (!((MuleConfiguration)this.getEntity()).getFlows().isEmpty()) {
            return ((MuleConfiguration)this.getEntity()).getFlows().get(((MuleConfiguration)this.getEntity()).getFlows().size() - 1);
        }
        return null;
    }

    @Override
    public String getAvailableName(String name) {
        if (this.getEntity() != null) {
            MuleConfigurationNamingSupport naming = new MuleConfigurationNamingSupport((MuleConfiguration)this.getEntity());
            return naming.getAvailableName(name);
        }
        return name;
    }
}

