/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow.decorator;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.decorator.Connector;

public class EntityDecorator<T extends IMessageFlowEntity>
extends Observable {
    public static final String PROP_INBOUND = "inbound";
    public static final String PROP_OUTBOUND = "outbound";
    public static final String PROPERTIES = "properties";
    private T entity;
    private List<Connector> inbound = new ArrayList<Connector>();
    private List<Connector> outbound = new ArrayList<Connector>();

    protected EntityDecorator(T entity) {
        this.entity = entity;
    }

    public T getEntity() {
        return this.entity;
    }

    public List<Connector> getInbound() {
        return this.inbound;
    }

    public void addInbound(Connector connector) {
        this.getInbound().add(connector);
        this.fireEvent(PROP_INBOUND);
    }

    public void removeInbound(Connector connector) {
        this.getInbound().remove(connector);
        this.fireEvent(PROP_INBOUND);
    }

    public List<Connector> getOutbound() {
        return this.outbound;
    }

    public void addOutbound(Connector connector) {
        this.getOutbound().add(connector);
        this.fireEvent(PROP_OUTBOUND);
    }

    public void removeOutbound(Connector connector) {
        this.getOutbound().remove(connector);
        this.fireEvent(PROP_OUTBOUND);
    }

    public void fireEvent(String id) {
        this.setChanged();
        this.notifyObservers(id);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.entity == null ? 0 : this.entity.hashCode());
        return result;
    }

    public String toString() {
        return String.valueOf(this.getEntity());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityDecorator other = (EntityDecorator)obj;
        return !(this.entity == null ? other.entity != null : !this.entity.equals(other.entity));
    }
}

