/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow.decorator;

import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;

public class EndpointDecorator
extends EntityDecorator<EndpointNode> {
    public static final String PROP_EXCHANGE_PATTERN = "exchangePattern";

    public EndpointDecorator(EndpointNode entity) {
        super(entity);
    }

    private String getPropertyValue(String property) {
        EndpointNode entity = (EndpointNode)this.getEntity();
        PropertyCollectionMap props = new PropertyCollectionMap(PropertiesUtils.excludeEmptyProperties(PropertiesUtils.toWritablePropertyCollection(entity.getProperties())));
        return props.getProperty(property, null);
    }

    public String getExchangePattern() {
        return this.getPropertyValue("exchange-pattern");
    }

    public boolean isRequestResponseMEP() {
        return "request-response".equals(this.getExchangePattern());
    }

    public boolean isOneWayMEP() {
        return "one-way".equals(this.getExchangePattern());
    }

    public boolean isResponseParticipant() {
        return Boolean.parseBoolean(this.getPropertyValue("response-participant"));
    }

    public void fireExchangePatternChanged() {
        this.fireEvent(PROP_EXCHANGE_PATTERN);
    }
}

