/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow.decorator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.ContainerOfMovableEntities;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.util.NamingUtils;

public class CompartmentLaneDecorator<T extends CompartmentLane>
extends EntityDecorator<T>
implements ContainerOfMovableEntities {
    private boolean showResponse = true;
    boolean editable = true;
    public static final String PROP_ENTITIES = "entities";
    public static final String PROP_INBOUND_ENDPOINT = "inbound.endpoint";
    public static final String PROP_OUTBOUND_ENDPOINT = "outbound";
    public static final String FIGURE_CHANGED = "figure.changed";
    private boolean horizontal;

    public CompartmentLaneDecorator(T entity, boolean editable, boolean isVertical) {
        super(entity);
        this.editable = editable;
        this.horizontal = !isVertical;
    }

    public CompartmentLaneDecorator(T entity, boolean editable) {
        super(entity);
        this.editable = editable;
        this.horizontal = true;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
    }

    public boolean isShowResponse() {
        return this.showResponse;
    }

    public void setShowResponse(boolean showResponse) {
        this.showResponse = showResponse;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void addEntity(IMessageFlowEntity entity) {
        ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries().add(entity);
        IElementWrapper laneElement = ((CompartmentLane)this.getEntity()).getElement();
        IElementWrapper childElement = entity.getElement();
        laneElement.add(childElement);
        this.setChanged();
        this.fireEvent(PROP_ENTITIES);
        if (entity instanceof EndpointNode && ((EndpointNode)entity).getDirection() == EndpointDirection.INBOUND) {
            this.fireEvent(PROP_INBOUND_ENDPOINT);
        }
    }

    public IMessageFlowEntity getFirstEntity() {
        List<IMessageFlowEntity> entities = ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries();
        if (!entities.isEmpty()) {
            return entities.get(0);
        }
        return null;
    }

    private boolean containsEntity(IMessageFlowEntity entity) {
        for (IMessageFlowEntity current : ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries()) {
            if (!current.equals(entity)) continue;
            return true;
        }
        return false;
    }

    public void addEntityBefore(IMessageFlowEntity entity, IMessageFlowEntity before) {
        int beforeIndex = this.findEntityIndex(before);
        if (beforeIndex == -1) {
            return;
        }
        if (this.containsEntity(entity)) {
            return;
        }
        IMessageFlowEntity added = entity;
        ArrayList<IMessageFlowEntity> updated = new ArrayList<IMessageFlowEntity>();
        for (IMessageFlowEntity current : ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries()) {
            if (current.equals(before)) {
                updated.add(added);
            }
            updated.add(current);
        }
        ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries().clear();
        ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries().addAll(updated);
        ((CompartmentLane)this.getEntity()).getElement().addBefore(entity.getElement(), before.getElement());
        this.fireEvent(PROP_ENTITIES);
        if (entity instanceof EndpointNode && beforeIndex == 0) {
            this.fireEvent(PROP_INBOUND_ENDPOINT);
        }
    }

    public void addEntityAfter(IMessageFlowEntity entity, IMessageFlowEntity after) {
        if (this.findEntityIndex(after) == -1) {
            return;
        }
        if (this.containsEntity(entity)) {
            return;
        }
        IMessageFlowEntity added = entity;
        ArrayList<IMessageFlowEntity> updated = new ArrayList<IMessageFlowEntity>();
        for (IMessageFlowEntity current : ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries()) {
            updated.add(current);
            if (!current.equals(after)) continue;
            updated.add(added);
        }
        ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries().clear();
        ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries().addAll(updated);
        ((CompartmentLane)this.getEntity()).getElement().addAfter(entity.getElement(), after.getElement());
        this.fireEvent(PROP_ENTITIES);
    }

    @Override
    public void removeEntity(IMessageFlowEntity entity, boolean fireEvent) {
        IMessageFlowEntity toDelete = null;
        for (IMessageFlowEntity current : ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries()) {
            if (!current.equals(entity)) continue;
            toDelete = current;
        }
        if (toDelete != null) {
            ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries().remove(toDelete);
            ((CompartmentLane)this.getEntity()).getElement().removeChild(toDelete.getElement());
            if (fireEvent) {
                this.fireEvent(PROP_ENTITIES);
            }
        }
    }

    public void removeEntity(MessageFlowEntity entity) {
        this.removeEntity(entity, true);
    }

    @Override
    public void moveMessageFlowEntityTo(IMessageFlowEntity entity, ContainerOfMovableEntities target, int targetIndex, boolean hasLastEntityToMove) {
        this.removeEntity(entity, false);
        target.addEntity(targetIndex, entity, false);
        this.fireEvent(PROP_ENTITIES);
        if (target instanceof MuleConfigurationDecorator) {
            ((EntityDecorator)((Object)target)).fireEvent("flows");
        } else {
            ((EntityDecorator)((Object)target)).fireEvent(PROP_ENTITIES);
            if (entity instanceof EndpointNode && targetIndex == 0 && hasLastEntityToMove) {
                ((EntityDecorator)((Object)target)).fireEvent(PROP_INBOUND_ENDPOINT);
            }
        }
    }

    public IMessageFlowEntity getEntityBefore(IMessageFlowEntity entity) {
        IMessageFlowEntity before = null;
        for (IMessageFlowEntity current : ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries()) {
            if (current.equals(entity)) {
                return before;
            }
            before = current;
        }
        return before;
    }

    public IMessageFlowEntity getEntityAfter(IMessageFlowEntity entity) {
        IMessageFlowEntity after = null;
        for (IMessageFlowEntity current : ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries()) {
            if (after != null && after.equals(entity)) {
                return current;
            }
            after = current;
        }
        return null;
    }

    @Override
    public IMessageFlowEntity getLastEntity() {
        if (!((CompartmentLane)this.getEntity()).getCompartmentLaneEntries().isEmpty()) {
            return ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries().get(((CompartmentLane)this.getEntity()).getCompartmentLaneEntries().size() - 1);
        }
        return null;
    }

    @Override
    public int findEntityIndex(IMessageFlowEntity entity) {
        if (entity == null) {
            return -1;
        }
        int index = 0;
        for (IMessageFlowEntity current : ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries()) {
            if (current.equals(entity)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public void addEntity(int index, IMessageFlowEntity messageFlowEntity, boolean fireEvent) {
        IMessageFlowEntity added = messageFlowEntity;
        ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries().add(index, added);
        ((CompartmentLane)this.getEntity()).getElement().add(index, messageFlowEntity.getElement());
        if (fireEvent) {
            this.fireEvent(PROP_ENTITIES);
            if (messageFlowEntity instanceof EndpointNode && index == 0) {
                this.fireEvent(PROP_INBOUND_ENDPOINT);
            }
        }
    }

    @Override
    public void addEntity(int index, IMessageFlowEntity messageFlowEntity) {
        this.addEntity(index, messageFlowEntity, true);
    }

    private Set<String> getListOfContainedEntityNames() {
        HashSet<String> names = new HashSet<String>();
        for (IMessageFlowEntity entity : ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries()) {
            if (!(entity instanceof MessageFlowNode)) continue;
            names.add(((MessageFlowNode)entity).getName());
        }
        return names;
    }

    @Override
    public String getAvailableName(String name) {
        return NamingUtils.getAvailableName(name, this.getListOfContainedEntityNames());
    }
}

