/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow.decorator;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;

public class CompartmentDecorator
extends EntityDecorator<Compartment> {
    public static final String PROP_LANES = "lanes";
    boolean editable = true;

    public CompartmentDecorator(Compartment entity, boolean editable) {
        super(entity);
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void addLane(CompartmentLane lane) {
        this.addLane(lane, true);
    }

    public void removeLane(CompartmentLane lane) {
        this.removeLane(lane, true);
    }

    public void removeLane(CompartmentLane lane, boolean fireEventEnabled) {
        ((Compartment)this.getEntity()).getLanes().remove(lane);
        IElementWrapper element = lane.getElement();
        if (element.getParent() != null) {
            ((Compartment)this.getEntity()).getElement().removeChild(element);
        }
        if (fireEventEnabled) {
            this.fireEvent(PROP_LANES);
        }
    }

    public void addLane(CompartmentLane lane, boolean fireEventEnabled) {
        ((Compartment)this.getEntity()).getLanes().add(lane);
        IElementWrapper element = lane.getElement();
        if (element.getParent() == null) {
            ((Compartment)this.getEntity()).getElement().add(element);
        }
        if (fireEventEnabled) {
            this.fireEvent(PROP_LANES);
        }
    }

    public void addLane(int index, CompartmentLane lane) {
        ((Compartment)this.getEntity()).getLanes().add(index, lane);
        IElementWrapper element = lane.getElement();
        if (element.getParent() == null) {
            ((Compartment)this.getEntity()).getElement().add(index, element);
        }
        this.fireEvent(PROP_LANES);
    }

    public int getRegularLanesCount() {
        return ((Compartment)this.getEntity()).getLanes().size();
    }

    public CompartmentLane getEmptyLane() {
        CompartmentLane emptyLane = null;
        for (CompartmentLane lane : ((Compartment)this.getEntity()).getLanes()) {
            if (!lane.getCompartmentLaneEntries().isEmpty()) continue;
            emptyLane = lane;
        }
        return emptyLane;
    }

    public List<CompartmentLane> getLanes() {
        return ((Compartment)this.getEntity()).getLanes();
    }

    public List<IMessageFlowEntity> getCompartmentLanesEntries() {
        ArrayList<IMessageFlowEntity> entries = new ArrayList<IMessageFlowEntity>();
        for (CompartmentLane lane : this.getLanes()) {
            for (IMessageFlowEntity entity : lane.getCompartmentLaneEntries()) {
                entries.add(entity);
            }
        }
        return entries;
    }
}

