/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public class UniqueList<T>
extends ArrayList<T> {
    private static final long serialVersionUID = 2650757477799960873L;
    private Comparator<T> keyProvider;

    public UniqueList(Comparator<T> keyProvider) {
        this.keyProvider = keyProvider;
    }

    @Override
    public boolean add(T e) {
        this.doRemove(e);
        boolean result = super.add(e);
        return result;
    }

    @Override
    public void add(int index, T element) {
        this.doRemove(element);
        super.add(index, element);
    }

    private void doRemove(T element) {
        int i = 0;
        for (Object value : this) {
            if (this.keyProvider.compare(value, element) == 0) {
                this.remove(i);
                return;
            }
            ++i;
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T element : c) {
            this.doRemove(element);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        for (T element : c) {
            this.doRemove(element);
        }
        return super.addAll(index, c);
    }
}

