/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.INodeNameProvider;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.model.module.SplitterDefinition;

public class SplitterNode
extends MessageFlowNode {
    protected PatternNode pattern;
    protected Compartment compartment;
    protected int index;
    private Map<RouteDefinition, Route> routes = new HashMap<RouteDefinition, Route>();

    protected SplitterNode(INodeNameProvider createNameProvider, IElementWrapper element) {
        super(createNameProvider, element);
    }

    @Override
    public void setDescription(String value) {
        super.setDescription(value);
        if (this.pattern != null) {
            this.pattern.setDescription(value);
        }
    }

    @Override
    public void setName(String value) {
        super.setName(value);
        if (this.pattern != null) {
            this.pattern.setName(value);
        }
    }

    public PatternNode getPattern() {
        return this.pattern;
    }

    public void setPattern(PatternNode value) {
        if (SplitterNode.different(this.pattern, value)) {
            value.setDescription(this.getDescription());
            value.setName(this.getName());
            this.pattern = value;
            this.notifyChanged("pattern");
        }
    }

    public Compartment getCompartment() {
        return this.compartment;
    }

    public void setCompartment(Compartment value) {
        if (SplitterNode.different(this.compartment, value)) {
            this.compartment = value;
            this.compartment.addObserver(this);
            this.notifyChanged("compartment");
        }
    }

    public Route getRoute(RouteDefinition routeDefinition) {
        if (this.routes.containsKey(routeDefinition)) {
            return this.routes.get(routeDefinition);
        }
        Route route = Route.create(routeDefinition);
        this.routes.put(routeDefinition, route);
        return route;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        if (SplitterNode.different(this.index, index)) {
            this.index = index;
            this.notifyChanged("index");
        }
    }

    @Override
    public void accept(MessageFlowEntityVisitor visitor) {
        visitor.visitSplitterNode(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.doUpdateWithProperties(o, this.compartment, arg, this.properties);
    }

    public void addRoute(RouteDefinition routeDef, Route route) {
        this.routes.put(routeDef, route);
        this.compartment.getLanes().add(route);
    }

    public SplitterDefinition getSplitterDefinition() {
        return (SplitterDefinition)this.getDefinition();
    }

    public Optional<RouteDefinition> getRouteToCreate() {
        if (!this.hasSplitterDefinition()) {
            return Optional.empty();
        }
        Stream routeDefinitions = this.getSplitterDefinition().getRouteDefinitions().stream();
        Optional<RouteDefinition> routeToCreate = routeDefinitions.filter(this::canCreateMore).findFirst();
        return routeToCreate;
    }

    private boolean canCreateMore(RouteDefinition definition) {
        return this.getRouteCountForType(definition) < (long)definition.getMaxOccurrence();
    }

    private long getRouteCountForType(RouteDefinition definition) {
        return this.compartment.getLanes().stream().filter(Route.class::isInstance).map(Route.class::cast).filter(route -> route.getDefinition().equals(definition)).count();
    }

    public boolean hasSplitterDefinition() {
        return this.getDefinition() instanceof SplitterDefinition;
    }
}

