/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.DefaultNodeNameProvider;
import org.mule.tooling.model.messageflow.INodeNameProvider;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PropertyNodeNameProvider;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.module.RouteDefinition;

public class Route
extends NestedContainer {
    private RouteDefinition routeDefinition;

    public Route(INodeNameProvider nameProvider, IElementWrapper element) {
        super(nameProvider, element);
    }

    public Route(INodeNameProvider nameProvider) {
        super(nameProvider);
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getDisplayName() {
        return StringUtils.abbreviate((String)this.nameProvider.getDisplayName(this), (int)25);
    }

    @Override
    public String getName() {
        return this.routeDefinition.getCaption();
    }

    @Override
    public RouteDefinition getDefinition() {
        return this.routeDefinition;
    }

    public void setDefinition(RouteDefinition routeDefinition) {
        this.routeDefinition = routeDefinition;
        this.nameProvider = Route.createNameProvider(routeDefinition);
    }

    public static INodeNameProvider createNameProvider(RouteDefinition routeDefinition) {
        return routeDefinition.isUseDocNameAsDisplayName() ? new DefaultNodeNameProvider(routeDefinition.getCaption()) : new PropertyNodeNameProvider(routeDefinition);
    }

    @Override
    public void accept(MessageFlowEntityVisitor visitor) {
        visitor.visitRoute(this);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getType() + ")";
    }

    @Override
    public boolean supportsMetadata() {
        return false;
    }

    public static Route create(RouteDefinition definition, IElementWrapper element) {
        INodeNameProvider provider = Route.createNameProvider(definition);
        Route route = new Route(provider, element);
        route.setDefinition(definition);
        return route;
    }

    public static Route create(RouteDefinition definition) {
        INodeNameProvider provider = Route.createNameProvider(definition);
        Route route = new Route(provider);
        route.setDefinition(definition);
        return route;
    }
}

