/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.ReadOnlyProperty;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;

public class ReadOnlyPropertyCollection
implements IReadOnlyPropertyCollection {
    public static final IReadOnlyPropertyCollection EMPTY_PROPERTY_COLLECTION = new ReadOnlyPropertyCollection(new PropertyCollection());
    private PropertyCollection propertyCollection;

    public ReadOnlyPropertyCollection(PropertyCollection propertyCollection) {
        this.propertyCollection = propertyCollection;
    }

    @Override
    public String getName() {
        return this.propertyCollection.getName();
    }

    @Override
    public List<IReadOnlyProperty> getProperties() {
        List<Property> properties = this.propertyCollection.getProperties();
        ArrayList<IReadOnlyProperty> readOnlyProperties = new ArrayList<IReadOnlyProperty>(properties.size());
        for (Property property : properties) {
            readOnlyProperties.add(new ReadOnlyProperty(property));
        }
        return readOnlyProperties;
    }

    @Override
    public List<IReadOnlyPropertyCollection> getPropertyCollections() {
        List<PropertyCollection> propertyCollections = this.propertyCollection.getPropertyCollections();
        ArrayList<IReadOnlyPropertyCollection> readOnlyPropertyCollection = new ArrayList<IReadOnlyPropertyCollection>(propertyCollections.size());
        for (PropertyCollection propertyCollection : propertyCollections) {
            readOnlyPropertyCollection.add(new ReadOnlyPropertyCollection(propertyCollection));
        }
        return readOnlyPropertyCollection;
    }

    @Override
    public IReadOnlyPropertyCollection getPropertyCollection(String name) {
        PropertyCollection propertyCollectionByName = this.propertyCollection.getPropertyCollection(name);
        return propertyCollectionByName != null ? new ReadOnlyPropertyCollection(propertyCollectionByName) : null;
    }

    @Override
    public IReadOnlyProperty getProperty(String name) {
        Property property = this.propertyCollection.getProperty(name);
        return property != null ? new ReadOnlyProperty(property) : null;
    }

    @Override
    public IElementWrapper getElement() {
        return this.propertyCollection.getElement();
    }

    @Override
    public PropertyCollectionMap toPropertyCollectionMap() {
        return new PropertyCollectionMap(this);
    }

    public int hashCode() {
        return this.propertyCollection.hashCode();
    }

    public boolean equals(Object obj) {
        return this.propertyCollection.equals(obj);
    }

    @Override
    public boolean isErased() {
        return this.propertyCollection.isErased();
    }

    public String toString() {
        return this.propertyCollection.toString();
    }
}

