/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.INodeNameProvider;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.NodeDefinition;

public class PropertyNodeNameProvider
implements INodeNameProvider {
    private String initialName;
    private NodeDefinition definition;

    public PropertyNodeNameProvider(NodeDefinition definition) {
        this(definition, null);
    }

    public PropertyNodeNameProvider(NodeDefinition definition, String initialName) {
        this.definition = definition;
        this.initialName = initialName;
    }

    @Override
    public String getDisplayName(IMessageFlowNode node) {
        String displayNameAtribute = this.definition.getDisplayNameAtribute();
        IReadOnlyPropertyCollection properties = node.getProperties();
        IReadOnlyProperty property = properties != null ? (IReadOnlyProperty)properties.getProperty(displayNameAtribute) : null;
        String displayName = property != null && property.getValue() != null ? property.getValue() : "";
        return displayName;
    }

    @Override
    public void setDisplayName(IMessageFlowNode node, String value) {
        Property property;
        String displayNameAtribute = this.definition.getDisplayNameAtribute();
        PropertyCollection properties = PropertiesUtils.toWritablePropertyCollection(node.getProperties());
        if (properties == null) {
            properties = new PropertyCollection();
            node.setProperties(properties);
        }
        if ((property = properties.getProperty(displayNameAtribute)) != null) {
            property.setValue(value);
        } else {
            properties.addProperty(new Property(displayNameAtribute, value));
        }
        node.setProperties(properties);
    }

    @Override
    public PropertyCollection buildPropertyCollection(IElementWrapper element) {
        PropertyCollection properties = new PropertyCollection(element);
        String displayNameAtribute = this.definition.getDisplayNameAtribute();
        Property property = properties.getProperty(displayNameAtribute);
        if (property != null) {
            property.setValue(this.initialName);
        } else {
            properties.addProperty(new Property(displayNameAtribute, this.initialName));
        }
        return properties;
    }
}

