/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.UniqueList;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;

public class PropertyCollection
extends Observable
implements IPropertyCollectionReadCapability<PropertyCollection, Property> {
    public static final String NAME_PROPETY = "name";
    public static final String BACKUP_STATE = "BACKUP_STATE";
    protected String name;
    protected boolean erased;
    protected List<Property> properties;
    protected List<PropertyCollection> propertyCollections;
    private IElementWrapper element;

    public PropertyCollection() {
        this(null);
    }

    public PropertyCollection(IElementWrapper element) {
        this.element = element;
        this.properties = new UniqueList<Property>(PropertyNameComparator.INSTANCE);
        this.propertyCollections = new UniqueList<PropertyCollection>(PropertyCollectionNameComparator.INSTANCE);
    }

    @Override
    public IElementWrapper getElement() {
        return this.element;
    }

    public void setElement(IElementWrapper element) {
        this.element = element;
    }

    @Override
    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public boolean isErased() {
        return this.erased;
    }

    public void setErased(boolean erased) {
        this.erased = erased;
    }

    public void addProperty(Property property) {
        this.getProperties().add(property);
    }

    public void addProperty(String name, String value) {
        this.getProperties().add(new Property(name, value));
    }

    @Override
    public Property getProperty(String name) {
        for (Property property : this.getProperties()) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public void removeProperty(Property property) {
        this.getProperties().remove(property);
    }

    public void removeProperty(String name) {
        Property property = this.getProperty(name);
        if (property != null) {
            this.getProperties().remove(property);
        }
    }

    public void setProperty(String name, String value) {
        this.getProperties().add(new Property(name, value));
    }

    public void addPropertyCollection(PropertyCollection propertyCollection) {
        this.getPropertyCollections().add(propertyCollection);
    }

    @Override
    public PropertyCollection getPropertyCollection(String name) {
        for (PropertyCollection propertyCollection : this.getPropertyCollections()) {
            if (!propertyCollection.getName().equals(name)) continue;
            return propertyCollection;
        }
        return null;
    }

    public void removePropertyCollection(PropertyCollection propertyCollection) {
        this.getPropertyCollections().remove(propertyCollection);
    }

    @Override
    public List<PropertyCollection> getPropertyCollections() {
        return this.propertyCollections;
    }

    public PropertyCollection getPropertyCollectionForEdit(IElementWrapper element) {
        PropertyCollection result = null;
        if (element != null) {
            for (PropertyCollection propertyCollection : this.propertyCollections) {
                if (!propertyCollection.getElement().equals(element)) continue;
                result = propertyCollection;
                break;
            }
        }
        if (result == null) {
            result = new PropertyCollection(element);
            this.propertyCollections.add(result);
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (MessageFlowEntity.different(this.name, value)) {
            this.name = value;
            this.notifyObservers(NAME_PROPETY);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.erased ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.propertyCollections == null ? 0 : this.propertyCollections.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyCollection other = (PropertyCollection)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.erased != other.erased) {
            return false;
        }
        if (this.properties == null) {
            if (other.properties != null) {
                return false;
            }
        } else {
            if (!PropertiesUtils.checkAllPropertiesArePresentIn(this.properties, other.properties)) {
                return false;
            }
            if (!PropertiesUtils.checkAllPropertiesArePresentIn(other.properties, this.properties)) {
                return false;
            }
        }
        if (this.propertyCollections == null || this.propertyCollections.isEmpty()) {
            if (other.propertyCollections != null && !other.propertyCollections.isEmpty()) {
                return false;
            }
        } else {
            if (!PropertiesUtils.checkAllPropertyCollectionsPresentIn(this.propertyCollections, other.propertyCollections)) {
                return false;
            }
            if (!PropertiesUtils.checkAllPropertyCollectionsPresentIn(other.propertyCollections, this.propertyCollections)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public PropertyCollectionMap toPropertyCollectionMap() {
        return new PropertyCollectionMap(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.properties != null && !this.properties.isEmpty()) {
            stringBuilder.append(this.properties);
            stringBuilder.append(",");
        }
        if (this.propertyCollections != null && !this.propertyCollections.isEmpty()) {
            stringBuilder.append(this.propertyCollections);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static final class PropertyCollectionNameComparator
    implements Comparator<PropertyCollection> {
        static final PropertyCollectionNameComparator INSTANCE = new PropertyCollectionNameComparator();

        private PropertyCollectionNameComparator() {
        }

        @Override
        public int compare(PropertyCollection o1, PropertyCollection o2) {
            return o1 == o2 || o1.getName() == null && o2.getName() == null ? 0 : o1.getName().compareTo(o2.getName());
        }
    }

    private static final class PropertyNameComparator
    implements Comparator<Property> {
        static PropertyNameComparator INSTANCE = new PropertyNameComparator();

        private PropertyNameComparator() {
        }

        @Override
        public int compare(Property o1, Property o2) {
            return o1 == o2 || o1.getName() == null && o2.getName() == null ? 0 : o1.getName().compareTo(o2.getName());
        }
    }
}

