/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import org.mule.tooling.model.messageflow.Event;

public class ObservableListDecorator<T>
extends Observable
implements List<T> {
    public static final String REMOVE_ALL = "removeAll";
    public static final String RETAIN_ALL = "retainAll";
    public static final String CLEAR = "clear";
    public static final String SET = "set";
    public static final String ADD_ALL = "addAll";
    public static final String REMOVE = "remove";
    public static final String ADD = "add";
    public static final List<String> events = Lists.newArrayList((Object[])new String[]{"removeAll", "retainAll", "clear", "set", "addAll", "remove", "add"});
    public static final List<String> addEvents = Lists.newArrayList((Object[])new String[]{"add", "addAll"});
    public static final List<String> removeEvents = Lists.newArrayList((Object[])new String[]{"clear", "remove", "removeAll"});
    private List<T> toBeDecorated;

    public static <X> ObservableListDecorator<X> create() {
        return new ObservableListDecorator(new ArrayList());
    }

    public ObservableListDecorator(List<T> toBeDecorated) {
        this.toBeDecorated = toBeDecorated;
    }

    @Override
    public int size() {
        return this.toBeDecorated.size();
    }

    @Override
    public boolean isEmpty() {
        return this.toBeDecorated.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.toBeDecorated.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.toBeDecorated.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.toBeDecorated.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toBeDecorated.toArray(a);
    }

    @Override
    public boolean add(T e) {
        boolean add = this.toBeDecorated.add(e);
        if (add) {
            this.setChanged();
            this.notifyObservers(Event.create(e, ADD));
        }
        return add;
    }

    @Override
    public boolean remove(Object o) {
        boolean remove = this.toBeDecorated.remove(o);
        if (remove) {
            this.setChanged();
            this.notifyObservers(Event.create(o, REMOVE));
        }
        return remove;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.toBeDecorated.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean addAll = this.toBeDecorated.addAll(c);
        if (addAll) {
            this.setChanged();
            this.notifyObservers(Event.create(c, ADD_ALL));
        }
        return addAll;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean addAll = this.toBeDecorated.addAll(index, c);
        if (addAll) {
            this.setChanged();
            this.notifyObservers(Event.create(c, ADD_ALL));
        }
        return addAll;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removeAll = this.toBeDecorated.removeAll(c);
        if (removeAll) {
            this.setChanged();
            this.notifyObservers(REMOVE_ALL);
        }
        return removeAll;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retainAll = this.toBeDecorated.retainAll(c);
        if (retainAll) {
            this.setChanged();
            this.notifyObservers(RETAIN_ALL);
        }
        return retainAll;
    }

    @Override
    public void clear() {
        this.toBeDecorated.clear();
        this.setChanged();
        this.notifyObservers(Event.create(null, CLEAR));
    }

    @Override
    public boolean equals(Object o) {
        return this.toBeDecorated.equals(o);
    }

    @Override
    public int hashCode() {
        return this.toBeDecorated.hashCode();
    }

    @Override
    public T get(int index) {
        return this.toBeDecorated.get(index);
    }

    @Override
    public T set(int index, T element) {
        T set = this.toBeDecorated.set(index, element);
        this.setChanged();
        this.notifyObservers(SET);
        return set;
    }

    @Override
    public void add(int index, T element) {
        this.toBeDecorated.add(index, element);
        this.setChanged();
        this.notifyObservers(Event.create(element, ADD));
    }

    @Override
    public T remove(int index) {
        T remove = this.toBeDecorated.remove(index);
        this.setChanged();
        this.notifyObservers(Event.create(remove, REMOVE));
        return remove;
    }

    @Override
    public int indexOf(Object o) {
        return this.toBeDecorated.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.toBeDecorated.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.toBeDecorated.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.toBeDecorated.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.toBeDecorated.subList(fromIndex, toIndex);
    }

    public String toString() {
        return this.toBeDecorated.toString();
    }
}

