/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import java.util.Observable;
import java.util.Observer;
import javax.xml.namespace.QName;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.generator.INodeXmlGenerator;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.INodeNameProvider;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MuleConfigurationXmlGenerator;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.ReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.module.NodeDefinition;

public class NestedContainer
extends CompartmentLane
implements Observer,
IMessageFlowNode {
    public static final String PROPERTIES = "properties";
    protected PropertyCollection properties;
    protected String description;
    protected INodeNameProvider nameProvider;
    protected String type;
    private boolean showsResponse;
    private NodeDefinition nestedDefinition;

    public NestedContainer(INodeNameProvider nameProvider) {
        this(nameProvider, null);
    }

    public NestedContainer(INodeNameProvider nameProvider, IElementWrapper element) {
        super(element);
        this.nameProvider = nameProvider;
        this.properties = new PropertyCollection();
    }

    @Override
    public void accept(MessageFlowEntityVisitor visitor) {
        visitor.visitNestedContainer(this);
    }

    @Override
    public IReadOnlyPropertyCollection getProperties() {
        if (this.properties == null) {
            this.properties = new PropertyCollection();
        }
        return new ReadOnlyPropertyCollection(this.properties);
    }

    @Override
    public PropertyCollection getPropertiesForEdit(IElementWrapper element) {
        if (element == null || element.equals(this.getElement())) {
            return this.properties;
        }
        return this.properties.getPropertyCollectionForEdit(element);
    }

    @Override
    public void setProperties(PropertyCollection value) {
        if (NestedContainer.different(this.properties, value)) {
            if (this.properties != null) {
                this.properties.deleteObserver(this);
            }
            this.properties = value;
            if (this.getElement() != null) {
                INodeXmlGenerator generator = MuleConfigurationXmlGenerator.getGeneratorForNode(this);
                generator.update(this);
            }
            if (this.properties != null) {
                this.properties.addObserver(this);
            }
            this.notifyChanged(PROPERTIES);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String value) {
        if (NestedContainer.different(this.description, value)) {
            QName qName;
            this.description = value;
            if (this.getElement() != null && (qName = this.element.getQName()) != null && MuleConfigurationXmlGenerator.supportsDocNS(qName, this)) {
                MuleConfigurationXmlGenerator.processDocDesc(this.element, this);
            }
        }
    }

    @Override
    public String getName() {
        return this.nameProvider.getDisplayName(this);
    }

    @Override
    public void setName(String value) {
        if (NestedContainer.different(this.getName(), value)) {
            this.nameProvider.setDisplayName(this, value);
            this.notifyChanged("name");
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.doUpdateWithProperties(o, this.laneEntries, arg, this.properties);
    }

    public void setType(String value) {
        if (NestedContainer.different(this.type, value)) {
            this.type = value;
            this.notifyChanged("type");
        }
    }

    public boolean isShowsResponse() {
        return this.showsResponse;
    }

    public void setShowsResponse(boolean showsResponse) {
        this.showsResponse = showsResponse;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public NodeDefinition getDefinition() {
        return this.nestedDefinition;
    }

    public void setDefinition(NodeDefinition nestedDefinition) {
        this.nestedDefinition = nestedDefinition;
    }
}

