/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import javax.xml.namespace.QName;
import org.dom4j.Namespace;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IConfigurableElement;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.QNameUtils;
import org.mule.tooling.core.generator.IContainerXmlGenerator;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.INodeXmlGenerator;
import org.mule.tooling.core.generator.ISplitterXmlGenerator;
import org.mule.tooling.core.generator.MuleNamespaces;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;

public class MuleConfigurationXmlGenerator {
    private static final String PARTIAL_MULESOFT_NAMESPACE_URI = "http://www.mulesoft.org";

    public IElementWrapper processContainer(Container container, IFlowTransformerContext context) {
        context.getEntityStack().push(container);
        NodeDefinition definition = container.getDefinition();
        IContainerXmlGenerator generator = this.getContainerXmlGenerator(container, definition);
        IElementWrapper created = generator.generate(container, definition, context, this);
        this.processDocumentation(created, container);
        this.addComponentId(created);
        return created;
    }

    public IContainerXmlGenerator getContainerXmlGenerator(IMessageFlowNode node, NodeDefinition definition) {
        return definition.getService(IContainerXmlGenerator.class);
    }

    public void processNestedContainer(NestedContainer nestedContainer, IFlowTransformerContext context) {
        if (!nestedContainer.getCompartmentLaneEntries().isEmpty()) {
            NestedContainerDefinition definition = (NestedContainerDefinition)context.getMuleProject().getModuleManager().getDefinition(nestedContainer.getType());
            if (!definition.isGraphical()) {
                this.startNestedContainer(nestedContainer, context);
            }
            this.processCompartmentLane(nestedContainer, context);
        }
    }

    public IElementWrapper processDeferredNestedContainer(NestedContainer nestedContainer, IFlowTransformerContext context) {
        return this.startNestedContainer(nestedContainer, context);
    }

    private IElementWrapper startNestedContainer(NestedContainer nestedContainer, IFlowTransformerContext context) {
        IElementWrapper created = null;
        INodeXmlGenerator generator = MuleConfigurationXmlGenerator.getGeneratorForNode(nestedContainer);
        if (generator != null) {
            created = generator.generate(nestedContainer, context);
        }
        return created;
    }

    public IElementWrapper processGlobalElement(IMessageFlowEntity entity, IFlowTransformerContext context) {
        if (entity instanceof GlobalElement) {
            GlobalElement element = (GlobalElement)entity;
            IMuleProject muleProject = context.getMuleProject();
            String versionWithEESign = muleProject.getServerDefinition().getVersionWithEESign();
            GlobalDefinition global = (GlobalDefinition)element.getDefinition();
            INodeXmlGenerator generator = this.getGeneratorForGlobal(global, element, versionWithEESign);
            if (global.getWrapInLocal() != null) {
                String wrapperLocalName = global.getWrapInLocal();
                IDocumentWrapper document = context.getDocumentWrapper();
                Namespace namespace = generator.getNamespaces(element).get(0);
                QName wrapperQName = QNameUtils.get(wrapperLocalName, namespace);
                IElementWrapper rootElement = document.getRootElement();
                IElementWrapper wrapInElement = this.selectOrCreateWrapper(wrapperQName, rootElement);
                IElementWrapper newGlobalElement = generator.generate(element, context);
                this.processDocumentation(newGlobalElement, element);
                this.addComponentId(newGlobalElement);
                element.setWrapInElement(wrapInElement);
                return newGlobalElement;
            }
            IElementWrapper elementWrapper = generator.generate(element, context);
            this.processDocumentation(elementWrapper, element);
            this.addComponentId(elementWrapper);
            return elementWrapper;
        }
        return null;
    }

    private IElementWrapper selectOrCreateWrapper(QName wrapperQName, IElementWrapper rootElement) {
        INodeListWrapper<IElementWrapper> possibleWrappersElements = rootElement.getChildElements(wrapperQName);
        IElementWrapper foundWrapperElement = possibleWrappersElements.get(0);
        if (foundWrapperElement == null) {
            foundWrapperElement = rootElement.getDocument().createElement(wrapperQName);
        }
        return foundWrapperElement;
    }

    public void processDocumentation(IElementWrapper element, IMessageFlowNode node) {
        QName qName;
        if (element != null && (qName = element.getQName()) != null && MuleConfigurationXmlGenerator.supportsDocNS(qName, node)) {
            this.processDocName(element, node);
            MuleConfigurationXmlGenerator.processDocDesc(element, node);
        }
    }

    public static void processDocDesc(IElementWrapper element, IMessageFlowNode node) {
        String description = node.getDescription();
        if (description != null) {
            QName descriptionQName = MuleNamespaces.getMuleDoc("description");
            IAttributeWrapper descriptionAttribute = element.getAttribute(descriptionQName);
            if (descriptionAttribute != null && description.trim().length() == 0) {
                element.removeAttribute(String.join((CharSequence)":", descriptionQName.getPrefix(), descriptionQName.getLocalPart()));
            } else if (descriptionAttribute == null || !description.equals(descriptionAttribute.getText())) {
                element.addAttribute(descriptionQName, description);
            }
        }
    }

    private void processDocName(IElementWrapper element, IMessageFlowNode node) {
        if (this.persistsDocName(node)) {
            String name = node.getName();
            QName nameQName = MuleNamespaces.getMuleDoc("name");
            IAttributeWrapper nameAttribute = element.getAttribute(nameQName);
            if (nameAttribute == null || !name.equals(nameAttribute.getText())) {
                element.addAttribute(nameQName, name);
            }
        }
    }

    public static boolean supportsDocNS(QName qName, IMessageFlowNode node) {
        return qName == null || !qName.getLocalPart().equalsIgnoreCase("property-placeholder");
    }

    protected boolean persistsDocName(IMessageFlowNode node) {
        boolean persist = true;
        NodeDefinition definition = node.getDefinition();
        if (definition != null) {
            persist = definition.isUseDocNameAsDisplayName();
        } else {
            GlobalDefinition global = MuleCorePlugin.getModuleManager().getGlobalDefinition(node.getType());
            persist = global.isUseDocNameAsDisplayName();
        }
        return persist;
    }

    public void processCompartment(Compartment compartment, IFlowTransformerContext context) {
        for (CompartmentLane lane : compartment.getLanes()) {
            this.processCompartmentLane(lane, context);
        }
    }

    public IElementWrapper processCompartmentLane(CompartmentLane lane, IFlowTransformerContext context) {
        return this.startCompartmentLane(lane, context);
    }

    public IElementWrapper processRoute(Route route, IFlowTransformerContext context) {
        SplitterNode splitter = (SplitterNode)context.getEntityStack().peek();
        ISplitterXmlGenerator sgen = (ISplitterXmlGenerator)MuleConfigurationXmlGenerator.getGeneratorForNode(splitter.getPattern());
        IElementWrapper routeElement = sgen.contributeRouteStart(route, context);
        if (routeElement instanceof IConfigurableElement) {
            IConfigurableElement configurable = (IConfigurableElement)((Object)routeElement);
            configurable.setXmlOrder(route.getDefinition().getXmlOrder());
        }
        return routeElement;
    }

    public IElementWrapper processMessageFlowEntity(IMessageFlowEntity entity, IFlowTransformerContext context) {
        DefaultMessageFlowEntityVisitorAdapter defaultMessageFlowEntityVisitorAdapter = new DefaultMessageFlowEntityVisitorAdapter(entity, context);
        entity.accept(defaultMessageFlowEntityVisitorAdapter);
        return defaultMessageFlowEntityVisitorAdapter.getResult();
    }

    public IElementWrapper processSplitter(SplitterNode splitterNode, IFlowTransformerContext context) {
        return this.startSplitterNode(splitterNode, context);
    }

    public IElementWrapper processMessageFlowNode(MessageFlowNode node, IFlowTransformerContext context) {
        return this.startNode(node, context);
    }

    protected IElementWrapper startCompartmentLane(CompartmentLane lane, IFlowTransformerContext context) {
        SplitterNode splitter;
        INodeXmlGenerator generator;
        IElementWrapper element = null;
        MessageFlowEntity scope = context.getEntityStack().peek();
        if (scope instanceof SplitterNode && (generator = MuleConfigurationXmlGenerator.getGeneratorForNode((splitter = (SplitterNode)scope).getPattern())) instanceof ISplitterXmlGenerator) {
            ISplitterXmlGenerator sgen = (ISplitterXmlGenerator)generator;
            element = sgen.contributeRouteStart(lane, context);
        }
        return element;
    }

    protected IElementWrapper startNode(MessageFlowNode node, IFlowTransformerContext context) {
        IElementWrapper element = null;
        INodeXmlGenerator generator = MuleConfigurationXmlGenerator.getGeneratorForNode(node);
        if (generator != null) {
            element = generator.generate(node, context);
            this.processDocumentation(element, node);
            this.addComponentId(element);
        }
        return element;
    }

    protected IElementWrapper startSplitterNode(SplitterNode splitterNode, IFlowTransformerContext context) {
        context.getEntityStack().push(splitterNode);
        IElementWrapper element = this.startNode(splitterNode, context);
        splitterNode.getCompartment().setElement(element);
        splitterNode.getPattern().setElement(element);
        return element;
    }

    public static INodeXmlGenerator getGeneratorForNode(IMessageFlowNode node) {
        String type = node.getType();
        NodeDefinition definition = node.getDefinition();
        if (definition == null) {
            throw new RuntimeException("Unknown node type in " + node.getClass().getName() + ": " + type);
        }
        Class<?> genClass = definition.getXmlGenerator();
        if (genClass == null) {
            return definition.getService(INodeXmlGenerator.class);
        }
        try {
            return (INodeXmlGenerator)genClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    protected INodeXmlGenerator getGeneratorForGlobal(GlobalDefinition definition, GlobalElement element, String version) {
        if (definition == null) {
            throw new RuntimeException("Unknown global type in " + element.getClass().getName() + ": " + element.getType());
        }
        Class<?> genClass = definition.getXmlGenerator();
        if (genClass == null) {
            return definition.getService(INodeXmlGenerator.class);
        }
        try {
            return (INodeXmlGenerator)genClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private void addComponentId(IElementWrapper element) {
        IAttributeWrapper metadataIdAttribute = element.getAttribute(ComponentId.ATTRIBUTE_ID);
        if (metadataIdAttribute == null && this.isMuleSoftElement(element)) {
            element.addAttribute(ComponentId.ATTRIBUTE_ID, ComponentId.create().toString());
        }
    }

    private boolean isMuleSoftElement(IElementWrapper element) {
        return element.getQName().getNamespaceURI().startsWith(PARTIAL_MULESOFT_NAMESPACE_URI);
    }

    private final class DefaultMessageFlowEntityVisitorAdapter
    extends MessageFlowEntityVisitorAdapter {
        private IElementWrapper result;
        private final IMessageFlowEntity entity;
        private final IFlowTransformerContext context;

        private DefaultMessageFlowEntityVisitorAdapter(IMessageFlowEntity entity, IFlowTransformerContext context) {
            this.entity = entity;
            this.context = context;
        }

        @Override
        public void visitContainer(Container container) {
            this.result = MuleConfigurationXmlGenerator.this.processContainer(container, this.context);
        }

        @Override
        public void visitNestedContainer(NestedContainer nestedContainer) {
            MuleConfigurationXmlGenerator.this.processNestedContainer(nestedContainer, this.context);
        }

        @Override
        public void visitSplitterNode(SplitterNode splitterNode) {
            SplitterNode node = (SplitterNode)this.entity;
            this.result = MuleConfigurationXmlGenerator.this.processSplitter(node, this.context);
        }

        @Override
        public void visitUnknownNode(UnknownNode unknownNode) {
            this.result = unknownNode.getElement();
        }

        @Override
        public void visitCommentNode(CommentContainer commentNode) {
            this.result = commentNode.getElement();
        }

        @Override
        public void visitCompartment(Compartment compartment) {
            this.result = MuleConfigurationXmlGenerator.this.processMessageFlowNode(compartment, this.context);
        }

        @Override
        public void visitEndpointNode(EndpointNode endpointNode) {
            this.result = MuleConfigurationXmlGenerator.this.processMessageFlowNode(endpointNode, this.context);
        }

        @Override
        public void visitPatternNode(PatternNode patternNode) {
            this.result = MuleConfigurationXmlGenerator.this.processMessageFlowNode(patternNode, this.context);
        }

        public IElementWrapper getResult() {
            return this.result;
        }
    }
}

