/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import java.util.List;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;

public abstract class MuleConfigurationTraverser
extends MessageFlowEntityVisitorAdapter {
    private final MuleConfiguration muleConfig;

    public MuleConfigurationTraverser(MuleConfiguration muleConfig) {
        this.muleConfig = muleConfig;
    }

    public void traverse() {
        List<IMessageFlowEntity> globalEntries = this.muleConfig.getGlobalEntries();
        for (IMessageFlowEntity globalEntry : globalEntries) {
            if (!(globalEntry instanceof GlobalElement)) continue;
            this.continueVisiting(globalEntry);
        }
        List<Container> flows = this.muleConfig.getFlows();
        for (Container flow : flows) {
            this.continueVisitingCompartment(flow);
        }
    }

    private void continueVisitingCompartment(Compartment compartment) {
        if (compartment != null) {
            this.continueVisiting(compartment.getLanes());
        }
    }

    private void continueVisiting(List<CompartmentLane> lanes) {
        for (CompartmentLane lane : lanes) {
            this.continueVisitingEntries(lane.getCompartmentLaneEntries());
        }
    }

    private void continueVisitingEntries(List<IMessageFlowEntity> compartmentLaneEntries) {
        for (IMessageFlowEntity entry : compartmentLaneEntries) {
            this.continueVisiting(entry);
        }
    }

    private void continueVisiting(final IMessageFlowEntity entity) {
        entity.accept(this);
        boolean shouldKeepVisiting = true;
        if (entity instanceof IMessageFlowNode) {
            shouldKeepVisiting = this.visitMessageFlowNode((IMessageFlowNode)entity);
        }
        if (shouldKeepVisiting) {
            entity.accept(new MessageFlowEntityVisitor(){

                @Override
                public void visitUnknownNode(UnknownNode unknownNode) {
                }

                @Override
                public void visitCommentNode(CommentContainer commentNode) {
                }

                @Override
                public void visitSplitterNode(SplitterNode splitterNode) {
                    MuleConfigurationTraverser.this.continueVisitingCompartment(splitterNode.getCompartment());
                }

                @Override
                public void visitPatternNode(PatternNode patternNode) {
                }

                @Override
                public void visitNestedContainer(NestedContainer nestedContainer) {
                    MuleConfigurationTraverser.this.continueVisitingEntries(nestedContainer.getCompartmentLaneEntries());
                }

                @Override
                public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
                }

                @Override
                public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
                }

                @Override
                public void visitGlobalElement(GlobalElement globalElement) {
                }

                @Override
                public void visitEndpointNode(EndpointNode endpointNode) {
                }

                @Override
                public void visitContainer(Container container) {
                    MuleConfigurationTraverser.this.continueVisitingCompartment(container);
                }

                @Override
                public void visitCompartmentLane(CompartmentLane lane) {
                    MuleConfigurationTraverser.this.continueVisitingEntries(((CompartmentLane)entity).getCompartmentLaneEntries());
                }

                @Override
                public void visitCompartment(Compartment compartment) {
                    MuleConfigurationTraverser.this.continueVisitingCompartment(compartment);
                }

                @Override
                public void visitRoute(Route route) {
                    this.visitCompartmentLane(route);
                }
            });
        }
    }

    protected boolean visitMessageFlowNode(IMessageFlowNode entity) {
        return true;
    }

    public MuleConfiguration getConfiguration() {
        return this.muleConfig;
    }
}

