/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.Scope;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.Event;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.ObservableListDecorator;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.ReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.model.messageflow.path.MulePathsCache;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.module.NodeDefinition;

public class MuleConfiguration
extends MessageFlowEntity
implements IMessageFlowNode,
Observer {
    protected List<IMessageFlowEntity> globalEntries;
    protected List<Container> flows;
    protected String description;
    protected String imageData;
    protected String name;
    protected String globalFunctionInline;
    private PropertyCollection value;
    private boolean isReadOnly;
    private IDocumentWrapper document;
    private NodeDefinition muleDefinition;
    private String scope = Scope.DEFAULT.getValue();
    private String visibility = Scope.Visibility.GLOBAL.getValue();
    private MulePathsCache pathsCache;

    public MuleConfiguration(IDocumentWrapper document) {
        super(document.getRootElement());
        this.document = document;
        this.value = new PropertyCollection();
    }

    public List<IMessageFlowEntity> getGlobalEntries() {
        if (this.globalEntries == null) {
            ObservableListDecorator observableList = ObservableListDecorator.create();
            observableList.addObserver(this);
            this.globalEntries = observableList;
        }
        return this.globalEntries;
    }

    public List<Container> getFlows() {
        if (this.flows == null) {
            ObservableListDecorator observableList = ObservableListDecorator.create();
            observableList.addObserver(this);
            this.flows = observableList;
        }
        return this.flows;
    }

    public Optional<Container> getFlow(String flowName) {
        if (this.flows == null) {
            return Optional.empty();
        }
        for (Container flow : this.flows) {
            if (!flow.getName().equals(flowName)) continue;
            return Optional.of(flow);
        }
        return Optional.empty();
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public String getGlobalFunctionInline() {
        return this.globalFunctionInline;
    }

    public void setGlobalFunctionInline(String globalFunctionInline) {
        this.globalFunctionInline = globalFunctionInline;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String value) {
        if (MuleConfiguration.different(this.description, value)) {
            this.description = value;
            this.notifyChanged("description");
        }
    }

    public String getImageData() {
        return this.imageData;
    }

    public void setImageData(String value) {
        if (MuleConfiguration.different(this.imageData, value)) {
            this.imageData = value;
            this.notifyChanged("imageData");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (MuleConfiguration.different(this.name, value)) {
            this.name = value;
            this.notifyChanged("name");
        }
    }

    @Override
    public void accept(MessageFlowEntityVisitor visitor) {
        visitor.visitMuleConfiguration(this);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public PropertyCollection getPropertiesForEdit(IElementWrapper element) {
        if (element == null) {
            throw new IllegalArgumentException("element cannot be null");
        }
        PropertyCollection result = null;
        if (element.equals(element)) {
            result = this.value;
        }
        return result;
    }

    @Override
    public IReadOnlyPropertyCollection getProperties() {
        return new ReadOnlyPropertyCollection(this.value);
    }

    @Override
    public void setProperties(PropertyCollection value) {
        this.value = value;
    }

    @Override
    public String getType() {
        return "http://www.mulesoft.org/schema/mule/core/mule";
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public MulePathsCache getPathsCache() {
        if (this.pathsCache == null) {
            this.pathsCache = new MulePathsCache(this);
        }
        return this.pathsCache;
    }

    @Override
    public void update(Observable o, Object arg) {
        Event event = (Event)arg;
        if (ObservableListDecorator.events.contains(event.getEventType()) || "pathChange".equals(event.getEventType())) {
            this.getPathsCache().invalidate();
        }
        this.doUpdate(o, this.flows, event);
    }

    public MulePath getPathFor(IMessageFlowEntity entity) {
        return this.getPathsCache().getPath(entity, null);
    }

    public MulePath getPathFor(IMessageFlowEntity entity, IMuleProject project) {
        return this.getPathsCache().getPath(entity, project);
    }

    public MessageFlowEntity getEntityFor(MulePath path) {
        return this.getPathsCache().getEntity(path, null);
    }

    public MessageFlowEntity getEntityFor(MulePath path, IMuleProject project) {
        return this.getPathsCache().getEntity(path, project);
    }

    public IDocumentWrapper getDocument() {
        return this.document;
    }

    @Override
    public NodeDefinition getDefinition() {
        if (this.muleDefinition == null) {
            this.muleDefinition = MuleCorePlugin.getModuleManager().getDefinition(this.getType());
        }
        return this.muleDefinition;
    }

    public boolean belongsTo(IMuleProject project) {
        return project.getConfigurationsCache().getConfigurations().contains(this);
    }
}

