/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import java.util.Observable;
import java.util.Observer;
import javax.xml.namespace.QName;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.generator.INodeXmlGenerator;
import org.mule.tooling.model.messageflow.DefaultNodeNameProvider;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.INodeNameProvider;
import org.mule.tooling.model.messageflow.IPathExpression;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfigurationXmlGenerator;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.ReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.module.NodeDefinition;

public abstract class MessageFlowNode
extends MessageFlowEntity
implements Observer,
IMessageFlowNode {
    public static final String TYPE_PROPERTY = "type";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String PATH_CHANGE = "pathChange";
    protected String type;
    private NodeDefinition definition;
    protected String description;
    protected PropertyCollection properties;
    protected INodeNameProvider nameProvider;

    public MessageFlowNode() {
        this(new DefaultNodeNameProvider());
    }

    public MessageFlowNode(INodeNameProvider nameProvider) {
        this(nameProvider, null);
    }

    public MessageFlowNode(IElementWrapper element) {
        this(new DefaultNodeNameProvider(), element);
    }

    public MessageFlowNode(INodeNameProvider nameProvider, IElementWrapper element) {
        super(element);
        this.nameProvider = nameProvider;
        this.properties = nameProvider.buildPropertyCollection(element);
    }

    @Override
    public IReadOnlyPropertyCollection getProperties() {
        if (this.properties == null) {
            this.properties = new PropertyCollection();
        }
        return new ReadOnlyPropertyCollection(this.properties);
    }

    @Override
    public PropertyCollection getPropertiesForEdit(IElementWrapper element) {
        if (element == null || element.equals(this.getElement())) {
            return this.properties;
        }
        return this.properties.getPropertyCollectionForEdit(element);
    }

    @Override
    public void setProperties(PropertyCollection value) {
        this.setProperties(value, true);
    }

    public void setProperties(PropertyCollection value, boolean fireNotification) {
        if (MessageFlowNode.different(this.getProperties(), value)) {
            INodeXmlGenerator generator;
            if (this.properties != null) {
                this.properties.deleteObserver(this);
            }
            this.properties = value;
            if (this.getElement() != null && (generator = MuleConfigurationXmlGenerator.getGeneratorForNode(this)) != null) {
                generator.update(this);
            }
            if (this.properties != null) {
                this.properties.addObserver(this);
            }
            if (fireNotification) {
                this.notifyChanged("properties");
            }
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String value) {
        if (MessageFlowNode.different(this.getDescription(), value)) {
            QName qName;
            this.description = value;
            if (this.getElement() != null && (qName = this.element.getQName()) != null && MuleConfigurationXmlGenerator.supportsDocNS(qName, this)) {
                MuleConfigurationXmlGenerator.processDocDesc(this.element, this);
            }
        }
    }

    @Override
    public String getName() {
        return this.nameProvider.getDisplayName(this);
    }

    @Override
    public void setName(String value) {
        if (MessageFlowNode.different(this.getName(), value)) {
            this.nameProvider.setDisplayName(this, value);
            if (this.getElement() != null && this.nameProvider instanceof DefaultNodeNameProvider) {
                new MuleConfigurationXmlGenerator().processDocumentation(this.getElement(), this);
            }
            this.notifyChanged("name");
            if (this.getDefinition() instanceof IPathExpression && ((IPathExpression)((Object)this.getDefinition())).getPathExpression().contains("name")) {
                this.notifyChanged(PATH_CHANGE);
            }
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        if (MessageFlowNode.different(this.type, value)) {
            this.type = value;
            this.notifyChanged(TYPE_PROPERTY);
        }
    }

    @Override
    public void accept(MessageFlowEntityVisitor visitor) {
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.properties) {
            this.notifyChanged("properties");
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public NodeDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(NodeDefinition definition) {
        this.definition = definition;
    }
}

