/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.messageflow.ModelGeneratorUtils;
import org.mule.tooling.core.dom.IConfigurableElement;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.model.messageflow.BasicMessageFlowFactory;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.DefaultNodeNameProvider;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.INodeNameProvider;
import org.mule.tooling.model.messageflow.MessageExchangePattern;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.MuleConfigurationXmlGenerator;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.PropertyNodeNameProvider;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.decorator.CommentDecorator;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.Connector;
import org.mule.tooling.model.messageflow.decorator.ConnectorType;
import org.mule.tooling.model.messageflow.decorator.ContainerDecorator;
import org.mule.tooling.model.messageflow.decorator.EndpointDecorator;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.GlobalElementDecorator;
import org.mule.tooling.model.messageflow.decorator.GlobalUnknownDecorator;
import org.mule.tooling.model.messageflow.decorator.NestedContainerDecorator;
import org.mule.tooling.model.messageflow.decorator.PatternDecorator;
import org.mule.tooling.model.messageflow.decorator.SplitterDecorator;
import org.mule.tooling.model.messageflow.decorator.UnknownDecorator;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitorAdapter;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.GraphicalContainerDefinition;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.model.module.SplitterDefinition;
import org.mule.tooling.utils.ObjectHolder;

public class MessageFlowFactory {
    public static void updateElementFromDefinition(IMessageFlowNode node, NodeDefinition modeDefinition, IFlowTransformerContext context) {
        Optional direction = node instanceof EndpointNode ? Optional.of((Object)((Object)((EndpointNode)node).getDirection())) : Optional.absent();
        IMessageFlowNode newNode = MessageFlowFactory.create(modeDefinition, (Optional<EndpointDirection>)direction, context);
        newNode.setName(node.getName());
        String description = node.getDescription();
        if (StringUtils.isNotBlank((String)description)) {
            newNode.setDescription(description);
        }
        MessageFlowEntity messageFlowNode = (MessageFlowEntity)((Object)node);
        messageFlowNode.setElement(newNode.getElement());
    }

    public static void configureNextCompartmentLane(Compartment compartment) {
        for (CompartmentLane compartmentLane : compartment.getLanes()) {
            IElementWrapper element = compartmentLane.getElement();
            if (!(element instanceof IConfigurableElement)) continue;
            ((IConfigurableElement)((Object)element)).setNextSibling(null);
        }
    }

    public static IMessageFlowNode create(NodeDefinition definition, final Optional<EndpointDirection> direction, final IFlowTransformerContext context) {
        final ObjectHolder result = new ObjectHolder();
        definition.accept(new NodeDefinitionVisitorAdapter(){

            @Override
            public void visitPatternDefinition(PatternDefinition patternDefinition) {
                result.set((Object)MessageFlowFactory.createPatternNode(context, patternDefinition));
            }

            @Override
            public void visitNestedContainerDefinition(NestedContainerDefinition nestedContainerDefinition) {
                result.set((Object)MessageFlowFactory.createDeferredNestedContainer(context, nestedContainerDefinition));
            }

            @Override
            public void visitGlobalDefinition(GlobalDefinition globalDefinition) {
                result.set((Object)MessageFlowFactory.createGlobalElement(context, globalDefinition));
            }

            @Override
            public void visitEndpointDefinition(EndpointDefinition endpointDefinition) {
                result.set((Object)MessageFlowFactory.createEndpointNode(context, endpointDefinition, direction.isPresent() ? (EndpointDirection)((Object)direction.get()) : EndpointDirection.INBOUND));
            }

            @Override
            public void visitContainerDefinition(ContainerDefinition containerDefinition) {
                result.set((Object)MessageFlowFactory.createContainer(context, null, containerDefinition));
            }

            @Override
            public void visitSplitterDefinition(SplitterDefinition splitterDefinition) {
                result.set((Object)MessageFlowFactory.createSplitterNode(context, splitterDefinition));
            }
        });
        return (IMessageFlowNode)result.get();
    }

    public static Route createRoute(IFlowTransformerContext context, RouteDefinition routeDefinition) {
        Route route = Route.create(routeDefinition);
        route.setType(routeDefinition.getId());
        IElementWrapper routeElement = MessageFlowFactory.generateRouteXml(context, route);
        route.setElement(routeElement);
        return route;
    }

    public static IElementWrapper generateLaneXml(IFlowTransformerContext context, CompartmentLane lane) {
        if (lane instanceof Route) {
            return MessageFlowFactory.generateRouteXml(context, (Route)lane);
        }
        return new MuleConfigurationXmlGenerator().processCompartmentLane(lane, context);
    }

    public static IElementWrapper generateRouteXml(IFlowTransformerContext context, Route route) {
        IElementWrapper routeElement = new MuleConfigurationXmlGenerator().processRoute(route, context);
        if (routeElement instanceof IConfigurableElement) {
            ((IConfigurableElement)((Object)routeElement)).setXmlOrder(route.getDefinition().getXmlOrder());
            ((IConfigurableElement)((Object)routeElement)).setMinimumChildElementsToShow(route.getDefinition().isRequired() ? 0 : 1);
        }
        return routeElement;
    }

    public static Compartment createCompartment(IElementWrapper element) {
        Compartment result = new Compartment(element);
        result.setEntityId(UUID.randomUUID().toString());
        return result;
    }

    public static CompartmentLane createCompartmentLane(IFlowTransformerContext context) {
        return MessageFlowFactory.createCompartmentLane(context, null);
    }

    public static CompartmentLane createCompartmentLane(IFlowTransformerContext context, IElementWrapper child) {
        CompartmentLane compartmentLaneNode;
        MessageFlowEntity parentEntity = context.getEntityStack().peek();
        if (parentEntity instanceof SplitterNode && ((SplitterNode)parentEntity).hasSplitterDefinition()) {
            SplitterNode splitterNode = (SplitterNode)parentEntity;
            RouteDefinition routeDefinition = splitterNode.getRouteToCreate().orElseThrow(() -> new RuntimeException("Router should have a default route type"));
            compartmentLaneNode = MessageFlowFactory.createRoute(context, routeDefinition);
        } else {
            compartmentLaneNode = MessageFlowFactory.createCompartmentLane(null);
            IElementWrapper compartmentLaneElement = new MuleConfigurationXmlGenerator().processCompartmentLane(compartmentLaneNode, context);
            if (compartmentLaneElement instanceof IConfigurableElement && child != null) {
                IConfigurableElement configurable = (IConfigurableElement)((Object)compartmentLaneElement);
                configurable.setIntermediateNodeConfig(parentEntity.getElement(), child);
            }
            compartmentLaneNode.setElement(compartmentLaneElement);
        }
        return compartmentLaneNode;
    }

    public static CompartmentLane createCompartmentLane(IElementWrapper element) {
        return MessageFlowFactory.createCompartmentLane(element, 1);
    }

    public static CompartmentLane createCompartmentLane(IElementWrapper element, int minimumChildElementsToShow) {
        CompartmentLane lane = new CompartmentLane(element);
        lane.setEntityId(UUID.randomUUID().toString());
        if (element instanceof IConfigurableElement) {
            ((IConfigurableElement)((Object)element)).setMinimumChildElementsToShow(minimumChildElementsToShow);
        }
        return lane;
    }

    public static EndpointNode createEndpointNode(IFlowTransformerContext context, EndpointDefinition definition, EndpointDirection direction) {
        EndpointNode endpointNode = MessageFlowFactory.createEndpointNode(definition, direction, null);
        IElementWrapper element = new MuleConfigurationXmlGenerator().processMessageFlowNode(endpointNode, context);
        endpointNode.setElement(element);
        return endpointNode;
    }

    public static EndpointNode createEndpointNode(EndpointDefinition definition, EndpointDirection direction, IElementWrapper element) {
        EndpointNode endpoint = new EndpointNode(BasicMessageFlowFactory.createNameProvider(definition, ModelGeneratorUtils.computeInitialName(definition, element)), element);
        endpoint.setDirection(direction);
        endpoint.setEntityId(UUID.randomUUID().toString());
        endpoint.setType(definition.getId());
        endpoint.setDefinition(definition);
        PropertyCollection props = endpoint.getPropertiesForEdit(element);
        MessageExchangePattern messageExchangePattern = MessageFlowFactory.createMessageExchangePattern(definition.getDefaultMep());
        props.setProperty("exchange-pattern", endpoint.toPropertyValue(messageExchangePattern));
        if (definition.isResponseParticipant()) {
            props.addProperty(new Property("response-participant", "true"));
        }
        return endpoint;
    }

    public static MessageExchangePattern createMessageExchangePattern(String moduleMep) {
        if ("OneWay".equals(moduleMep)) {
            return MessageExchangePattern.ONE_WAY;
        }
        return MessageExchangePattern.REQUEST_RESPONSE;
    }

    public static Container createContainer(IFlowTransformerContext context, MuleConfiguration muleConfiguration, ContainerDefinition containerDefinition) {
        Container container = BasicMessageFlowFactory.createContainer(muleConfiguration, containerDefinition, null);
        IElementWrapper containerElement = new MuleConfigurationXmlGenerator().processContainer(container, context);
        container.setElement(containerElement);
        IElementWrapper previousNestedContainerElement = null;
        List<NestedContainerDefinition> nestedContainerDefinitions = containerDefinition.getNestedContainerDefinitions();
        for (NestedContainerDefinition nestedContainerDefinition : nestedContainerDefinitions) {
            NestedContainer nestedContainer;
            IFlowTransformerContext deferredContext = NewFlowTransformerContext.create(context.getMuleProject(), context.getDocumentWrapper());
            if (nestedContainerDefinition instanceof GraphicalContainerDefinition) {
                nestedContainer = MessageFlowFactory.createGraphicalContainer(deferredContext, containerElement, nestedContainerDefinition);
                MessageFlowFactory.configureNestedContainerElement(nestedContainer.getElement(), previousNestedContainerElement, nestedContainerDefinition);
            } else {
                nestedContainer = MessageFlowFactory.createDeferredNestedContainer(deferredContext, nestedContainerDefinition);
                MessageFlowFactory.configureNestedContainerElement(nestedContainer.getElement(), previousNestedContainerElement, nestedContainerDefinition);
                container.getElement().add(nestedContainer.getElement());
            }
            previousNestedContainerElement = nestedContainer.getElement();
            container.addNestedContainer(nestedContainer);
        }
        return container;
    }

    public static Container createContainer(MuleConfiguration muleConfiguration, ContainerDefinition containerDefinition, IElementWrapper element) {
        Container container = BasicMessageFlowFactory.createContainer(muleConfiguration, containerDefinition, element);
        Map<String, IElementWrapper> elementsByDefinitionType = MessageFlowFactory.mapElementsByDefinition(element);
        IElementWrapper previousNestedContainerElement = null;
        List<NestedContainerDefinition> nestedContainerDefinitions = containerDefinition.getNestedContainerDefinitions();
        for (NestedContainerDefinition nestedContainerDefinition : nestedContainerDefinitions) {
            NestedContainer nestedContainer;
            IElementWrapper childElement = elementsByDefinitionType.get(nestedContainerDefinition.getId());
            if (childElement != null) {
                nestedContainer = BasicMessageFlowFactory.createNestedContainer(nestedContainerDefinition, childElement);
                MessageFlowFactory.configureNestedContainerElement(childElement, previousNestedContainerElement, nestedContainerDefinition);
                previousNestedContainerElement = childElement;
            } else {
                IFlowTransformerContext context = NewFlowTransformerContext.create(MuleCorePlugin.getDesignContext().getMuleProject(), element.getDocument());
                if (nestedContainerDefinition instanceof GraphicalContainerDefinition) {
                    nestedContainer = MessageFlowFactory.createGraphicalContainer(context, element, nestedContainerDefinition);
                    MessageFlowFactory.configureNestedContainerElement(nestedContainer.getElement(), previousNestedContainerElement, nestedContainerDefinition);
                } else {
                    nestedContainer = MessageFlowFactory.createDeferredNestedContainer(context, nestedContainerDefinition);
                    MessageFlowFactory.configureNestedContainerElement(nestedContainer.getElement(), previousNestedContainerElement, nestedContainerDefinition);
                    container.getElement().add(nestedContainer.getElement());
                }
                previousNestedContainerElement = nestedContainer.getElement();
            }
            container.addNestedContainer(nestedContainer);
        }
        return container;
    }

    public static CommentContainer createCommentContainer(MuleConfiguration muleConfiguration, IElementWrapper element, boolean standalone) {
        return BasicMessageFlowFactory.createCommentContainer(muleConfiguration, element, standalone);
    }

    public static NestedContainer createGraphicalContainer(IFlowTransformerContext context, IElementWrapper element, NestedContainerDefinition nestedContainerDefinition) {
        NestedContainer nestedContainer = BasicMessageFlowFactory.createGraphicalNestedContainer((GraphicalContainerDefinition)nestedContainerDefinition, element);
        IElementWrapper nestedElement = new MuleConfigurationXmlGenerator().processDeferredNestedContainer(nestedContainer, context);
        if (nestedElement instanceof IConfigurableElement) {
            IConfigurableElement configurableElement = (IConfigurableElement)((Object)nestedElement);
            configurableElement.setVirtualNodeConfig(element, new LinkedList<IElementWrapper>());
        }
        nestedContainer.setElement(nestedElement);
        return nestedContainer;
    }

    public static void configureNestedContainerElement(IElementWrapper nestedContainerElement, IElementWrapper previousNestedContainerElement, NestedContainerDefinition nestedContainerDefinition) {
        if (nestedContainerElement instanceof IConfigurableElement) {
            ((IConfigurableElement)((Object)nestedContainerElement)).setMinimumChildElementsToShow(1);
            ((IConfigurableElement)((Object)nestedContainerElement)).setXmlOrder(nestedContainerDefinition.getXmlOrder());
            MessageFlowFactory.configureNextSibling(previousNestedContainerElement, nestedContainerElement);
        }
    }

    private static void configureNextSibling(IElementWrapper nestedContainerElement, IElementWrapper nextNestedContainerElement) {
        if (nestedContainerElement != null) {
            if (nestedContainerElement instanceof IConfigurableElement) {
                ((IConfigurableElement)((Object)nestedContainerElement)).setNextSibling(nextNestedContainerElement);
            }
            if (nextNestedContainerElement instanceof IConfigurableElement) {
                ((IConfigurableElement)((Object)nextNestedContainerElement)).setPreviousSibling(nestedContainerElement);
            }
        }
    }

    private static Map<String, IElementWrapper> mapElementsByDefinition(IElementWrapper element) {
        HashMap<String, IElementWrapper> elementsByDefinition = new HashMap<String, IElementWrapper>();
        INodeListWrapper<IElementWrapper> childNodes = element.getChildElements();
        for (IElementWrapper childNode : childNodes) {
            elementsByDefinition.put(MessageFlowFactory.getDefinitionTypeFrom(childNode), childNode);
        }
        return elementsByDefinition;
    }

    public static NestedContainer createNestedContainer(NestedContainerDefinition definition) {
        NestedContainer nestedContainer = new NestedContainer(MessageFlowFactory.createNameProvider(definition));
        MessageFlowFactory.initializeNestedContainerPattern(definition, nestedContainer);
        return nestedContainer;
    }

    public static NestedContainer createDeferredNestedContainer(IFlowTransformerContext context, NestedContainerDefinition definition) {
        NestedContainer nestedContainer = MessageFlowFactory.createNestedContainer(definition);
        IElementWrapper element = new MuleConfigurationXmlGenerator().processDeferredNestedContainer(nestedContainer, context);
        nestedContainer.setElement(element);
        return nestedContainer;
    }

    private static void initializeNestedContainerPattern(NestedContainerDefinition definition, NestedContainer pattern) {
        pattern.setType(definition.getId());
        pattern.setDefinition(definition);
        pattern.setEntityId(UUID.randomUUID().toString());
        pattern.setName(definition.getDocName());
        pattern.setShowsResponse(definition.isShowsResponse());
    }

    public static PatternNode createPatternNode(IFlowTransformerContext context, NodeDefinition definition) {
        PatternNode patternNode = MessageFlowFactory.createPatternNode(definition, null);
        IElementWrapper element = new MuleConfigurationXmlGenerator().processMessageFlowNode(patternNode, context);
        patternNode.setElement(element);
        return patternNode;
    }

    public static PatternNode createPatternNode(NodeDefinition definition, IElementWrapper element) {
        PatternNode pattern = new PatternNode(BasicMessageFlowFactory.createNameProvider(definition, ModelGeneratorUtils.computeInitialName(definition, element)), element);
        pattern.setType(definition.getId());
        pattern.setDefinition(definition);
        pattern.setEntityId(UUID.randomUUID().toString());
        return pattern;
    }

    public static SplitterNode createSplitterNode(IFlowTransformerContext context, NodeDefinition definition) {
        SplitterNode splitterNode = MessageFlowFactory.createSplitterNode(definition, null);
        IElementWrapper element = new MuleConfigurationXmlGenerator().processSplitter(splitterNode, context);
        splitterNode.setElement(element);
        return splitterNode;
    }

    public static SplitterNode createSplitterNode(NodeDefinition definition, IElementWrapper element) {
        SplitterNode splitter = new SplitterNode(BasicMessageFlowFactory.createNameProvider(definition, ModelGeneratorUtils.computeInitialName(definition, element)), element);
        splitter.setType(definition.getId());
        splitter.setDefinition(definition);
        splitter.setEntityId(UUID.randomUUID().toString());
        splitter.setCompartment(MessageFlowFactory.createCompartment(element));
        splitter.setPattern(MessageFlowFactory.createPatternNode(definition, element));
        return splitter;
    }

    public static GlobalElement createGlobalElement(IFlowTransformerContext context, GlobalDefinition definition) {
        GlobalElement globalElementNode = MessageFlowFactory.createGlobalElement(definition, null);
        IElementWrapper element = new MuleConfigurationXmlGenerator().processGlobalElement(globalElementNode, context);
        globalElementNode.setElement(element);
        return globalElementNode;
    }

    public static GlobalElement createGlobalElement(GlobalDefinition definition, IElementWrapper element) {
        GlobalElement global = new GlobalElement(new DefaultNodeNameProvider(ModelGeneratorUtils.computeInitialName(definition, element)), element);
        global.setType(definition.getId());
        global.setDefinition(definition);
        global.setEntityId("!!!" + UUID.randomUUID().toString());
        return global;
    }

    public static EntityDecorator<?> getWrappedEntity(IMessageFlowEntity entity) {
        final ObjectHolder decorator = new ObjectHolder();
        entity.accept(new MessageFlowEntityVisitorAdapter(){

            @Override
            public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
                super.visitMuleConfiguration(muleConfiguration);
            }

            @Override
            public void visitGlobalElement(GlobalElement globalElement) {
                decorator.set((Object)new GlobalElementDecorator(globalElement));
            }

            @Override
            public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
                decorator.set((Object)new GlobalUnknownDecorator(globalUnknown));
            }

            @Override
            public void visitContainer(Container container) {
                decorator.set(new ContainerDecorator<Container>(container));
            }

            @Override
            public void visitNestedContainer(NestedContainer nestedContainer) {
                decorator.set((Object)new NestedContainerDecorator(nestedContainer));
            }

            @Override
            public void visitEndpointNode(EndpointNode endpointNode) {
                decorator.set((Object)new EndpointDecorator(endpointNode));
            }

            @Override
            public void visitPatternNode(PatternNode patternNode) {
                decorator.set((Object)new PatternDecorator(patternNode));
            }

            @Override
            public void visitSplitterNode(SplitterNode splitterNode) {
                decorator.set((Object)new SplitterDecorator(splitterNode));
            }

            @Override
            public void visitUnknownNode(UnknownNode unknownNode) {
                decorator.set((Object)new UnknownDecorator(unknownNode));
            }

            @Override
            public void visitCommentNode(CommentContainer commentNode) {
                decorator.set((Object)new CommentDecorator(commentNode));
            }

            @Override
            public void visitCompartmentLane(CompartmentLane lane) {
                decorator.set(new CompartmentLaneDecorator<CompartmentLane>(lane, true));
            }
        });
        if (decorator.isNull()) {
            throw new RuntimeException("No wrapper available for " + entity.getClass().toString());
        }
        return (EntityDecorator)decorator.get();
    }

    public static UnknownNode createUnknownNode(IElementWrapper element) {
        UnknownNode unknown = new UnknownNode(element);
        unknown.setEntityId(UUID.randomUUID().toString());
        return unknown;
    }

    public static UnknownNode createUnknownNode(IFlowTransformerContext context, String name) {
        UnknownNode unknown = new UnknownNode();
        IElementWrapper element = context.getDocumentWrapper().createElement(new QName(name));
        unknown.setElement(element);
        unknown.setContent(element.asXML());
        return unknown;
    }

    public static GlobalUnknown createGlobalUnknownNode(IElementWrapper element) {
        GlobalUnknown unknown = new GlobalUnknown(element);
        unknown.setEntityId(UUID.randomUUID().toString());
        return unknown;
    }

    public static PropertyCollection createPropertyCollection() {
        return new PropertyCollection();
    }

    public static void createConnector(EntityDecorator<?> source, EntityDecorator<?> target, ConnectorType type) {
        Connector connector = new Connector(source, target, type);
        source.addOutbound(connector);
        target.addInbound(connector);
    }

    public static String getDefinitionTypeFrom(IElementWrapper childElement) {
        QName childElementQName = childElement.getQName();
        String name = childElementQName.getLocalPart();
        String type = childElementQName.getNamespaceURI() + "/" + name;
        return type;
    }

    private static INodeNameProvider createNameProvider(NodeDefinition definition) {
        return definition.isUseDocNameAsDisplayName() ? new DefaultNodeNameProvider() : new PropertyNodeNameProvider(definition);
    }

    public static Route createRoute(IElementWrapper element, RouteDefinition routeDefinition) {
        return MessageFlowFactory.createRoute(element, 1, routeDefinition);
    }

    public static Route createRoute(IElementWrapper element, int minimumChildElementsToShow, RouteDefinition routeDefinition) {
        Route lane = Route.create(routeDefinition, element);
        ModelGeneratorUtils.addDescription(element, lane);
        lane.setEntityId(UUID.randomUUID().toString());
        lane.setType(routeDefinition.getId());
        if (element instanceof IConfigurableElement) {
            ((IConfigurableElement)((Object)element)).setMinimumChildElementsToShow(minimumChildElementsToShow);
            ((IConfigurableElement)((Object)element)).setXmlOrder(routeDefinition.getXmlOrder());
        }
        return lane;
    }
}

