/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import java.util.Observable;
import java.util.Observer;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.Event;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;

public class MessageFlowEntity
extends Observable
implements IMessageFlowEntity,
Observer {
    public static final String NAME_PROPERTY = "name";
    public static final String PROPERTIES = "properties";
    protected String entityId;
    protected IElementWrapper element;

    public MessageFlowEntity(IElementWrapper element) {
        this.element = element;
    }

    protected void setElement(IElementWrapper element) {
        this.element = element;
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(String value) {
        if (MessageFlowEntity.different(this.entityId, value)) {
            this.entityId = value;
            this.notifyChanged("entityId");
        }
    }

    @Override
    public IElementWrapper getElement() {
        return this.element;
    }

    @Override
    public void accept(MessageFlowEntityVisitor visitor) {
    }

    @Override
    public void notifyChanged(String propertyName) {
        this.setChanged();
        this.notifyObservers(Event.create(this, propertyName));
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    protected void doUpdateWithProperties(Observable o, Object ownChangeSource, Object arg, PropertyCollection properties) {
        if (o == properties) {
            this.notifyChanged(PROPERTIES);
        } else {
            this.doUpdate(o, ownChangeSource, arg);
        }
    }

    protected void doUpdate(Observable o, Object ownChangeSource, Object arg) {
        if (arg instanceof Event) {
            Event event = (Event)arg;
            if (o == ownChangeSource) {
                if ("add".equals(event.getEventType())) {
                    event.getSource().addObserver(this);
                } else if ("addAll".equals(event.getEventType())) {
                    for (MessageFlowEntity source : event.getSourceAsList()) {
                        source.addObserver(this);
                    }
                }
                if ("remove".equals(event.getEventType())) {
                    event.getSource().deleteObserver(this);
                }
            }
            this.notifyChangedEvent(event);
        }
    }

    public static boolean different(Object value1, Object value2) {
        if (value1 == null || value2 == null) {
            return value1 != value2;
        }
        return !value1.equals(value2);
    }

    private void notifyChangedEvent(Object event) {
        this.setChanged();
        this.notifyObservers(event);
    }
}

