/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.INodeNameProvider;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.MessageExchangePattern;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;

public class EndpointNode
extends MessageFlowNode {
    private static final String ONE_WAY = "one-way";
    private static final String REQUEST_RESPONSE = "request-response";
    public static final String EXCHANGE_PATTERN_PROPERTY_NAME = "exchange-pattern";
    protected String endpointUri;
    protected String endpointTemplate;
    protected EndpointDirection direction;

    public EndpointNode(INodeNameProvider nameProvider) {
        this(nameProvider, null);
    }

    public EndpointNode(INodeNameProvider nameProvider, IElementWrapper element) {
        super(nameProvider, element);
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setEndpointUri(String value) {
        if (EndpointNode.different(this.endpointUri, value)) {
            this.endpointUri = value;
            this.notifyChanged("endpointUri");
        }
    }

    public String getEndpointTemplate() {
        return this.endpointTemplate;
    }

    public void setEndpointTemplate(String value) {
        if (EndpointNode.different(this.endpointTemplate, value)) {
            this.endpointTemplate = value;
            this.notifyChanged("endpointTemplate");
        }
    }

    public EndpointDirection getDirection() {
        return this.direction;
    }

    public boolean isInbound() {
        return this.getDirection().equals((Object)EndpointDirection.INBOUND);
    }

    public void setDirection(EndpointDirection value) {
        if (EndpointNode.different((Object)this.direction, (Object)value)) {
            this.direction = value;
            this.notifyChanged("direction");
        }
    }

    public MessageExchangePattern getMessageExchangePattern() {
        IReadOnlyProperty property;
        if (this.getProperties() != null && (property = (IReadOnlyProperty)this.getProperties().getProperty(EXCHANGE_PATTERN_PROPERTY_NAME)) != null && !StringUtils.isBlank((String)property.getValue())) {
            return this.toExchangePattern(property.getValue());
        }
        return null;
    }

    public void setMessageExchangePattern(MessageExchangePattern value) {
        if (EndpointNode.different((Object)this.getMessageExchangePattern(), (Object)value)) {
            PropertyCollection newProperties = PropertiesUtils.toWritablePropertyCollection(this.getProperties());
            newProperties.setProperty(EXCHANGE_PATTERN_PROPERTY_NAME, this.toPropertyValue(value));
            this.setProperties(newProperties);
            this.notifyChanged("messageExchangePattern");
        }
    }

    public String toPropertyValue(MessageExchangePattern exchangePattern) {
        return exchangePattern == MessageExchangePattern.REQUEST_RESPONSE ? REQUEST_RESPONSE : ONE_WAY;
    }

    public MessageExchangePattern toExchangePattern(String propertyValue) {
        return REQUEST_RESPONSE.equals(propertyValue) ? MessageExchangePattern.REQUEST_RESPONSE : MessageExchangePattern.ONE_WAY;
    }

    @Override
    public void accept(MessageFlowEntityVisitor visitor) {
        visitor.visitEndpointNode(this);
    }
}

