/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import java.util.List;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.INodeNameProvider;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;

public class Container
extends Compartment {
    private static final int DEFAULT_NESTED_CONTAINER_INDEX = 0;
    private String containerBehavior;

    public Container(INodeNameProvider nameProvider, IElementWrapper element) {
        super(nameProvider, element);
    }

    @Override
    public void accept(MessageFlowEntityVisitor visitor) {
        visitor.visitContainer(this);
    }

    public void addNestedContainer(NestedContainer nestedContainer) {
        this.getLanes().add(nestedContainer);
    }

    public NestedContainer getNestedContainer(String type) {
        List<CompartmentLane> lanes = this.getLanes();
        for (CompartmentLane compartmentLane : lanes) {
            NestedContainer nestedContainer = (NestedContainer)compartmentLane;
            if (!nestedContainer.getType().equals(type)) continue;
            return nestedContainer;
        }
        return null;
    }

    public List<NestedContainer> getNestedContainers() {
        List<CompartmentLane> nestedContainers = this.getLanes();
        return nestedContainers;
    }

    public NestedContainer getDefaultNestedContainer() {
        return (NestedContainer)this.getLanes().get(0);
    }

    public void setContainerBehavior(String containerBehavior) {
        this.containerBehavior = containerBehavior;
    }

    public String getContainerBehavior() {
        return this.containerBehavior;
    }

    public boolean isEmpty() {
        for (CompartmentLane lane : this.lanes) {
            if (lane.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

