/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IAttributeListWrapper;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.QNameUtils;
import org.mule.tooling.core.generator.IMuleNamespaces;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.ServerMatcher;
import org.mule.tooling.core.utils.ComponentIdGeneratorSupplier;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;

public final class ComponentId {
    private static final ServerMatcher SERVERS_NOT_SUPPORTING_ID_OF_ROUTES = ServerMatcher.fromString("[4.0,4.1.5)");
    private final String id;
    public static final ComponentId UNDEFINED = new ComponentId(null);
    public static final QName ATTRIBUTE_ID = QNameUtils.get("id", IMuleNamespaces.NS_MULE_DOC);
    private static final String ATTRIBUTE_ID_QUALIFIED_NAME = QNameUtils.toQualifiedName(ATTRIBUTE_ID);

    public static boolean acceptsAutogeneratedDocIdValue(IMessageFlowNode node) {
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        if (muleProject == null) {
            throw new IllegalStateException("Mule Project cannot be null");
        }
        IServerDefinition serverDefinition = muleProject.getServerDefinition();
        return ComponentId.nodeSupportsIdInServerDefinition(node, serverDefinition);
    }

    private static boolean nodeSupportsIdInServerDefinition(IMessageFlowNode node, IServerDefinition serverDefinition) {
        return !SERVERS_NOT_SUPPORTING_ID_OF_ROUTES.matches(serverDefinition) || node.supportsMetadata();
    }

    private ComponentId(String id) {
        this.id = id;
    }

    public boolean isDefined() {
        return this.id != null;
    }

    public boolean isUndefined() {
        return !this.isDefined();
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentId other = (ComponentId)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public static ComponentId create() {
        ComponentIdGeneratorSupplier supplier = EclipseContextHelper.createFromStudioContext(ComponentIdGeneratorSupplier.class);
        return new ComponentId(supplier.get().generate());
    }

    public static ComponentId fromDocId(String id) {
        return id != null ? new ComponentId(id) : UNDEFINED;
    }

    public static ComponentId from(IMessageFlowEntity node) {
        return Optional.ofNullable(node).map(IMessageFlowEntity::getElement).map(element -> {
            IAttributeListWrapper attributeListWrapper = element.getAttributes();
            IAttributeWrapper docIdAttribute = null;
            for (IAttributeWrapper attributeWrapper : attributeListWrapper) {
                if (!ATTRIBUTE_ID_QUALIFIED_NAME.equals(QNameUtils.toQualifiedName(attributeWrapper.getQName()))) continue;
                docIdAttribute = attributeWrapper;
                break;
            }
            return docIdAttribute;
        }).map(attribute -> ComponentId.fromDocId(attribute.getText())).orElse(UNDEFINED);
    }

    public static ComponentId from(PropertyCollection node) {
        return Optional.ofNullable(node).map(x -> x.getProperty("doc:id")).map(x -> ComponentId.fromDocId(x.getValue())).orElse(UNDEFINED);
    }

    public static ComponentId getOrCreate(IMessageFlowNode node) {
        ComponentId componentId = ComponentId.from(node);
        if (componentId.isUndefined() && ComponentId.acceptsAutogeneratedDocIdValue(node)) {
            componentId = ComponentId.create();
            PropertyCollection newProperties = PropertiesUtils.toWritablePropertyCollection(node.getProperties());
            newProperties.setProperty("doc:id", componentId.toString());
            node.setProperties(newProperties);
        }
        return componentId;
    }

    public static void copyComponentId(IMessageFlowNode from, IMessageFlowNode to) {
        ComponentId componentId = ComponentId.from(from);
        if (!componentId.isUndefined()) {
            PropertyCollection newProperties = PropertiesUtils.toWritablePropertyCollection(to.getProperties());
            newProperties.setProperty("doc:id", componentId.toString());
            to.setProperties(newProperties);
        }
    }

    public static void copyComponentId(PropertyCollectionMap from, PropertyCollectionMap to) {
        ComponentId componentId = ComponentId.from(from.asPropertyCollection());
        if (!componentId.isUndefined()) {
            to.addProperty("doc:id", componentId.toString());
        }
    }

    public String getId() {
        return this.id;
    }
}

