/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import java.util.List;
import java.util.Observable;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.ObservableListDecorator;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;

public class CompartmentLane
extends MessageFlowEntity {
    public static final String LANE_ENTRIES_PROPERTY = "laneEntry";
    protected List<IMessageFlowEntity> laneEntries;
    protected boolean hadOnlyOneElement;
    protected int index;

    public CompartmentLane() {
        this(null);
    }

    public CompartmentLane(IElementWrapper element) {
        super(element);
    }

    public Optional<IMessageFlowEntity> getEntry(int index) {
        if (!this.isEmpty() && this.laneEntries.size() > index) {
            return Optional.of(this.laneEntries.get(index));
        }
        return Optional.empty();
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.laneEntries);
    }

    public List<IMessageFlowEntity> getCompartmentLaneEntries() {
        if (this.laneEntries == null) {
            ObservableListDecorator observableListDecorator = ObservableListDecorator.create();
            observableListDecorator.addObserver(this);
            this.laneEntries = observableListDecorator;
        }
        return this.laneEntries;
    }

    public void setHadOnlyOneElement(boolean hadOnlyOneElement) {
        if (CompartmentLane.different(this.hadOnlyOneElement, hadOnlyOneElement)) {
            this.hadOnlyOneElement = hadOnlyOneElement;
            this.notifyChanged("hadOnlyOneElement");
        }
    }

    public boolean getHadOnlyOneElement() {
        return this.hadOnlyOneElement;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        if (CompartmentLane.different(this.index, index)) {
            this.index = index;
            this.notifyChanged("index");
        }
    }

    @Override
    public void setElement(IElementWrapper element) {
        super.setElement(element);
    }

    @Override
    public void accept(MessageFlowEntityVisitor visitor) {
        visitor.visitCompartmentLane(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.doUpdate(o, this.laneEntries, arg);
    }
}

