/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.INodeNameProvider;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;

public class CommentContainer
extends Container {
    private static final String OPEN_COMMENT = "<!-- [STUDIO:";
    private static final String CLOSE_COMMENT = " [STUDIO] -->";
    private static final String CLOSING_BRACKET = "]";
    private static final String CLOSING_BRACKET_ESCAPE = "&#93;";
    private static final String DOUBLE_DASH = "--";
    private static final String DOUBLE_DASH_ESCAPE = "&#45;&#45;";
    private static final String QUOTE = "\"";
    private static final String QUOTE_ESCAPE = "&quot;";
    private boolean standalone;

    public CommentContainer(INodeNameProvider nameProvider, IElementWrapper element, boolean standalone) {
        super(nameProvider, element);
        this.standalone = standalone;
    }

    public String getComment() {
        String[] commentSplitted = this.getElement().asXML().split(QUOTE);
        String name = commentSplitted == null || commentSplitted.length < 1 ? "" : commentSplitted[1];
        return this.escapeUnescapeComment(this.getCommentText(name), false);
    }

    @Override
    public void accept(MessageFlowEntityVisitor visitor) {
        visitor.visitCommentNode(this);
    }

    @Override
    public String getDisplayName() {
        String[] commentSplitted = this.getElement().asXML().split(QUOTE);
        return commentSplitted == null || commentSplitted.length < 1 ? "Comment" : this.unescapeDisplayName(commentSplitted[1]);
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public void updateComment(String text) {
        IElementWrapper comment = this.getElement();
        comment.setNodeValue(" [STUDIO:\"" + comment.asXML().split(QUOTE)[1] + "\"] " + this.escapeUnescapeComment(text, true) + " [STUDIO] ");
    }

    @Override
    public boolean supportsMetadata() {
        return false;
    }

    private String getCommentText(String commentName) {
        return this.getElement().asXML().replace("<!-- [STUDIO:\"" + commentName + "\"]", "").replace(CLOSE_COMMENT, "");
    }

    private String escapeUnescapeComment(String comment, boolean shouldEscape) {
        return shouldEscape ? comment.replaceAll(DOUBLE_DASH, DOUBLE_DASH_ESCAPE).replaceAll(CLOSING_BRACKET, CLOSING_BRACKET_ESCAPE) : comment.replaceAll(DOUBLE_DASH_ESCAPE, DOUBLE_DASH).replaceAll(CLOSING_BRACKET_ESCAPE, CLOSING_BRACKET);
    }

    private String unescapeDisplayName(String displayName) {
        return displayName.replaceAll(QUOTE_ESCAPE, QUOTE).replaceAll(DOUBLE_DASH_ESCAPE, DOUBLE_DASH);
    }
}

