/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.messageflow;

import java.util.UUID;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.messageflow.ModelGeneratorUtils;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.QNameUtils;
import org.mule.tooling.core.generator.IMuleNamespaces;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.DefaultNodeNameProvider;
import org.mule.tooling.model.messageflow.GraphicalContainer;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.INodeNameProvider;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PropertyNodeNameProvider;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.GraphicalContainerDefinition;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;

class BasicMessageFlowFactory {
    BasicMessageFlowFactory() {
    }

    public static Container createContainer(MuleConfiguration muleConfiguration, ContainerDefinition containerDefinition, IElementWrapper element) {
        Container container = new Container(BasicMessageFlowFactory.createNameProvider(containerDefinition, ModelGeneratorUtils.computeInitialName(muleConfiguration, containerDefinition, ModelGeneratorUtils.getElementName(element))), element);
        return BasicMessageFlowFactory.doCreateContainer(muleConfiguration, containerDefinition, container, element);
    }

    public static CommentContainer createCommentContainer(MuleConfiguration muleConfiguration, IElementWrapper element, boolean standalone) {
        CommentContainer container = new CommentContainer(new DefaultNodeNameProvider(ModelGeneratorUtils.getElementName(element)), element, standalone);
        container.setType("Comment");
        container.setEntityId(UUID.randomUUID().toString());
        return container;
    }

    public static Container doCreateContainer(MuleConfiguration muleConfiguration, ContainerDefinition containerDefinition, Container container, IElementWrapper element) {
        container.setType(containerDefinition.getId());
        container.setContainerBehavior(containerDefinition.getContainerBehavior());
        container.setDefinition(containerDefinition);
        container.setEntityId(UUID.randomUUID().toString());
        return container;
    }

    public static NestedContainer createNestedContainer(NestedContainerDefinition definition, IElementWrapper element) {
        NestedContainer nestedContainer = new NestedContainer(BasicMessageFlowFactory.createNameProvider(definition), element);
        BasicMessageFlowFactory.initializeNestedContainerPattern(definition, nestedContainer);
        return nestedContainer;
    }

    public static NestedContainer createGraphicalNestedContainer(GraphicalContainerDefinition definition, IElementWrapper element) {
        GraphicalContainer pattern = new GraphicalContainer(BasicMessageFlowFactory.createNameProvider(definition), element);
        BasicMessageFlowFactory.initializeNestedContainerPattern(definition, pattern);
        return pattern;
    }

    private static INodeNameProvider createNameProvider(NodeDefinition definition) {
        return BasicMessageFlowFactory.createNameProvider(definition, null);
    }

    public static INodeNameProvider createNameProvider(NodeDefinition definition, String initialName) {
        return definition.isUseDocNameAsDisplayName() ? new DefaultNodeNameProvider(initialName) : new PropertyNodeNameProvider(definition, initialName);
    }

    private static void initializeNestedContainerPattern(NestedContainerDefinition definition, NestedContainer nestedContainer) {
        nestedContainer.setType(definition.getId());
        nestedContainer.setDefinition(definition);
        nestedContainer.setEntityId(UUID.randomUUID().toString());
        nestedContainer.setName(definition.getDocName());
        nestedContainer.setShowsResponse(definition.isShowsResponse());
    }

    protected void processDocumentation(IElementWrapper nodeElement, IMessageFlowNode node) {
        if (nodeElement != null && this.supportsDocName(nodeElement, node)) {
            String description;
            if (this.persistsDocName(node)) {
                nodeElement.addAttribute(QNameUtils.get("name", IMuleNamespaces.NS_MULE_DOC), node.getName());
            }
            if ((description = node.getDescription()) != null && description.trim().length() > 0) {
                nodeElement.addAttribute(QNameUtils.get("description", IMuleNamespaces.NS_MULE_DOC), description);
            }
        }
    }

    private boolean supportsDocName(IElementWrapper element, IMessageFlowNode node) {
        String elementName = element.getName();
        return !elementName.equalsIgnoreCase("property-placeholder");
    }

    protected boolean persistsDocName(IMessageFlowNode node) {
        boolean persist = true;
        NodeDefinition definition = node.getDefinition();
        if (definition != null) {
            persist = definition.isUseDocNameAsDisplayName();
        } else {
            GlobalDefinition global = MuleCorePlugin.getModuleManager().getGlobalDefinition(node.getType());
            persist = global.isUseDocNameAsDisplayName();
        }
        return persist;
    }
}

