/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.core.module;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IPath;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.internal.core.module.AbstractBaseArtifact;

public class JarBasedArtifact
extends AbstractBaseArtifact {
    private final File jarFile;
    private final String version;

    public JarBasedArtifact(String id, String version, File zipFile) {
        super(id);
        this.jarFile = zipFile;
        this.version = version;
    }

    @Override
    public File getOriginalFile() {
        return this.jarFile;
    }

    @Override
    public URL getResource(IPath path) throws IOException {
        return this.getResource(path.toString());
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public File getRoot() throws IOException {
        return this.getContributionBaseDirectory();
    }

    @Override
    public <T> T newInstance(String customClass) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        throw new UnsupportedOperationException("Cannot load class from directory artifacts.");
    }

    @Override
    public URL getResource(String path) throws IOException {
        File baseDir = this.getRoot();
        File file = new File(baseDir, path);
        if (file.exists()) {
            return file.toURI().toURL();
        }
        return null;
    }

    private File getContributionBaseDirectory() throws IOException {
        File baseDirectory = this.getLocationAtWorkspace();
        if (!baseDirectory.exists()) {
            if (!baseDirectory.mkdirs()) {
                if (!baseDirectory.exists()) {
                    throw new IOException("Could not create directory " + baseDirectory.getAbsolutePath());
                }
            } else {
                this.unzipExtension(this.jarFile, baseDirectory);
            }
        }
        return baseDirectory;
    }

    private void unzipExtension(File contributionZip, File destDir) throws IOException {
        Path basePath = destDir.toPath();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ZipFile zipFile = new ZipFile(contributionZip);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    File entryDestination = new File(destDir, entry.getName());
                    Path entryPath = entryDestination.getAbsoluteFile().toPath().normalize();
                    if (!entryPath.startsWith(basePath)) {
                        throw new SecurityException("Attempted to write content at illegal location: " + String.valueOf(entryPath.toAbsolutePath()));
                    }
                    if (entry.isDirectory()) {
                        entryDestination.mkdirs();
                        continue;
                    }
                    entryDestination.getParentFile().mkdirs();
                    Throwable throwable2 = null;
                    Object var12_16 = null;
                    try (InputStream in = zipFile.getInputStream(entry);){
                        Files.copy(in, entryPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SecurityException ex) {
            MuleCorePlugin.logWarning("A potential security issue was found unzipping: " + contributionZip.getAbsolutePath(), ex);
            FileUtils.deleteQuietly((File)destDir);
        }
    }

    @Override
    public String getContainerName() {
        return this.jarFile.getName().replace(".jar", "");
    }
}

