/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.core.module;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.mule.tooling.internal.core.module.AbstractBaseArtifact;
import org.osgi.framework.Bundle;

public class BundleBasedArtifact
extends AbstractBaseArtifact {
    private final Bundle bundle;
    private final String containerName;

    public BundleBasedArtifact(Bundle bundle) {
        super(bundle.getSymbolicName());
        this.bundle = bundle;
        this.containerName = bundle.getSymbolicName();
    }

    public BundleBasedArtifact(Bundle bundle, String containerName) {
        super(bundle.getSymbolicName());
        this.bundle = bundle;
        this.containerName = containerName;
    }

    @Override
    public File getOriginalFile() throws IOException {
        File zipFile = null;
        File root = FileLocator.getBundleFile((Bundle)this.bundle);
        File[] fileArray = root.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("zip")) {
                zipFile = file;
                break;
            }
            ++n2;
        }
        return zipFile;
    }

    @Override
    public String getId() {
        return this.bundle.getSymbolicName();
    }

    @Override
    public URL getResource(IPath path) throws IOException {
        return this.getResource(path.toString());
    }

    @Override
    public String getVersion() {
        return this.bundle.getVersion().toString();
    }

    @Override
    public File getRoot() throws MalformedURLException, IOException {
        return this.getContributionBaseDirectory();
    }

    @Override
    public <T> T newInstance(String customClass) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.bundle.loadClass(customClass).newInstance();
    }

    @Override
    public URL getResource(String path) throws IOException {
        File file = this.lookupAtContributionDir(path);
        if (file.exists()) {
            return file.toURI().toURL();
        }
        File resource = this.lookupAtBundleLocation(path);
        if (resource.exists()) {
            return resource.toURI().toURL();
        }
        return null;
    }

    protected File lookupAtBundleLocation(String path) throws IOException {
        File root = FileLocator.getBundleFile((Bundle)this.bundle);
        File resource = new File(root, path);
        return resource;
    }

    protected File lookupAtContributionDir(String path) throws IOException {
        File baseDir = this.getContributionBaseDirectory();
        File file = new File(baseDir, path);
        return file;
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    private File getContributionBaseDirectory() throws IOException {
        File zipFile = this.getOriginalFile();
        File baseDirectory = this.getLocationAtWorkspace();
        if (!baseDirectory.exists()) {
            if (!baseDirectory.mkdirs()) {
                if (!baseDirectory.exists()) {
                    throw new IOException("Could not create directory " + baseDirectory.getAbsolutePath());
                }
            } else if (zipFile != null && zipFile.exists()) {
                this.unzipContributionLibDependencies(zipFile, new File(baseDirectory, "lib"));
            }
        }
        return baseDirectory;
    }

    private void unzipContributionLibDependencies(File contributionZip, File destDir) throws IOException, FileNotFoundException {
        try (ZipFile zip = new ZipFile(contributionZip, 1);){
            Enumeration<? extends ZipEntry> zipEntries = zip.entries();
            if (!destDir.exists()) {
                destDir.mkdirs();
            }
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                String zipEntryName = zipEntry.getName();
                File zipFile = new File(destDir, zipEntryName);
                if (zipEntry.isDirectory() || !zipFile.getParentFile().getName().equals("lib")) continue;
                FileUtils.copyInputStreamToFile((InputStream)zip.getInputStream(zipEntry), (File)new File(destDir, zipFile.getName()));
            }
        }
    }
}

