/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.exchange.client.internal;

import java.util.Collections;
import java.util.List;
import org.mule.tooling.exchange.client.ExternalServiceCallException;
import org.mule.tooling.exchange.client.GraphServiceResponse;
import org.mule.tooling.exchange.client.internal.ResultsSupplier;

public class PagingResponse<T>
implements GraphServiceResponse<T> {
    private final int limit;
    private final ResultsSupplier<T> resultsSupplier;
    private List<T> results;

    public PagingResponse(List<T> results, ResultsSupplier<T> resultsSupplier) {
        this.results = results;
        this.limit = results.size();
        this.resultsSupplier = resultsSupplier;
    }

    public static <T> PagingResponse<T> create(List<T> results, ResultsSupplier<T> resultsSupplier) {
        if (results == null || results.isEmpty()) {
            throw new IllegalArgumentException("results cannot be a null/empty list");
        }
        return new PagingResponse<T>(results, resultsSupplier);
    }

    @Override
    public List<T> getElements() {
        return this.results;
    }

    @Override
    public boolean hasMoreElements() {
        return this.results.size() % this.limit == 0;
    }

    @Override
    public List<T> fetchNextElements() throws ExternalServiceCallException {
        try {
            List<T> newResults = this.resultsSupplier.getResults(this.results.size(), this.limit);
            this.results.addAll(newResults);
            return newResults;
        }
        catch (InterruptedException interruptedException) {
            return Collections.emptyList();
        }
    }
}

