/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.exchange.client.internal;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.mule.tooling.core.net.ConnectionManager;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.exchange.client.ExternalServiceCallException;
import org.mule.tooling.exchange.client.GraphQlClient;

public class HttpClientGraphQlClient
implements GraphQlClient {
    private static final String KEY_QUERY = "query";
    private static final String KEY_VARIABLES = "variables";
    private static final String SEARCH_FAILURE_MSG = "Failed query at URL ''{0}''. Response: ''{1}''";
    private final String url;
    private final HttpClient client;
    private final Optional<String> accessToken;

    private HttpClientGraphQlClient(ConnectionManager connectionManager, String url, Optional<String> accessToken) {
        this.url = url;
        this.accessToken = accessToken;
        this.client = this.createClient(connectionManager);
    }

    protected CloseableHttpClient createClient(ConnectionManager connectionManager) {
        try {
            return connectionManager.createApacheClientForUri(new URI(this.url));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL for creating GraphQL client: " + this.url, e);
        }
    }

    private String getJsonRequest(String graphqlQueryString) {
        JsonObject jsonObject = new JsonObject();
        JsonObject variables = new JsonObject();
        jsonObject.add(KEY_VARIABLES, (JsonElement)new JsonPrimitive(variables.toString()));
        jsonObject.add(KEY_QUERY, (JsonElement)new JsonPrimitive(graphqlQueryString));
        return jsonObject.toString();
    }

    @Override
    public String query(String query) throws ExternalServiceCallException {
        try {
            return this.query(query, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String query(String query, IProgressMonitor monitor) throws ExternalServiceCallException, InterruptedException {
        HttpUriRequest request = this.requestBuild(query);
        Pair result = (Pair)HttpClientGraphQlClient.executeInterruptible(this.client, request, monitor, httpResponse -> this.readResponse(query, httpResponse));
        Boolean success = (Boolean)result.getKey();
        if (!success.booleanValue()) {
            Throwable responseAsException = (Throwable)result.getValue();
            this.throwException(responseAsException);
        }
        String successPayload = (String)result.getValue();
        return successPayload;
    }

    private HttpUriRequest requestBuild(String query) {
        RequestBuilder requestBuilder = RequestBuilder.post().setUri(this.url).setEntity((HttpEntity)new StringEntity(this.getJsonRequest(query), ContentType.APPLICATION_JSON));
        if (this.accessToken.isPresent()) {
            requestBuilder.setHeader("Authorization", "Bearer " + this.accessToken.get());
        }
        return requestBuilder.build();
    }

    private void throwException(Throwable exception) throws ExternalServiceCallException {
        if (exception instanceof ExternalServiceCallException) {
            throw (ExternalServiceCallException)exception;
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        throw (RuntimeException)exception;
    }

    private Pair<Boolean, Object> readResponse(String queryExecuted, HttpResponse responseToRead) {
        try {
            StatusLine statusLine = responseToRead.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (Response.Status.fromStatusCode((int)statusCode).getFamily() == Response.Status.Family.SUCCESSFUL) {
                return Pair.of((Object)true, (Object)this.toString(responseToRead));
            }
            return Pair.of((Object)false, (Object)this.getException(queryExecuted, responseToRead, statusLine));
        }
        catch (RuntimeException e) {
            return Pair.of((Object)false, (Object)e);
        }
    }

    private String toString(HttpResponse response) {
        try {
            return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException | IllegalStateException e) {
            return e.getMessage();
        }
    }

    private ExternalServiceCallException getException(String query, HttpResponse response, StatusLine clientResponseStatus) {
        ExternalServiceCallException exception;
        String responseBody = this.toString(response);
        try {
            Map responseMap = (Map)new Gson().fromJson(responseBody, HashMap.class);
            exception = ExternalServiceCallException.create(MessageFormat.format(SEARCH_FAILURE_MSG, this.url, clientResponseStatus.getReasonPhrase()), responseMap, query, responseBody);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            exception = ExternalServiceCallException.create("Received malformed query response.", null, query, responseBody);
        }
        exception.setStatusCode(clientResponseStatus.getStatusCode());
        exception.setReasonPhrase(clientResponseStatus.getReasonPhrase());
        return exception;
    }

    private static <T> T executeInterruptible(HttpClient client, HttpUriRequest request, IProgressMonitor monitor, ResponseHandler<T> responseHandler) throws ExternalServiceCallException, InterruptedException {
        String threadNameFormat = HttpClientGraphQlClient.class.getSimpleName() + "-" + RandomUtils.nextInt((int)1, (int)10000) + "-%d";
        ExecutorService executor = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat(threadNameFormat).build());
        try {
            Future<Object> future = executor.submit(() -> client.execute(request, responseHandler));
            executor.submit(() -> {
                while (!monitor.isCanceled() && !future.isDone()) {
                    try {
                        Thread.sleep(400L);
                    }
                    catch (InterruptedException interruptedException) {
                        monitor.setCanceled(true);
                    }
                }
                if (monitor.isCanceled()) {
                    request.abort();
                }
            });
            Object object = future.get();
            return (T)object;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (monitor.isCanceled() || cause instanceof InterruptedIOException) {
                throw new InterruptedException();
            }
            if (cause instanceof ClientProtocolException) {
                String newMsg = HttpClientGraphQlClient.getHostFromException((ClientProtocolException)cause);
                throw new ExternalServiceCallException(newMsg, cause);
            }
            if (cause instanceof UnknownHostException) {
                throw new ExternalServiceCallException("An error was found while searching in exchange. Please make sure that your Internet connection is working properly.", cause);
            }
            throw new ExternalServiceCallException("Unexpected error", cause);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private static String getHostFromException(ClientProtocolException e) {
        return e.getMessage().replaceAll("java\\.net\\.UnknownHostException: ", "");
    }

    public static class Builder {
        @Inject
        private ConnectionManager connectionManager;
        private String url;
        private String accessToken;

        public static Builder create() {
            return EclipseContextHelper.createFromStudioContext(Builder.class);
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder withAccessToken(Optional<String> accessToken) {
            this.accessToken = accessToken.orElse(null);
            return this;
        }

        public HttpClientGraphQlClient build() {
            return new HttpClientGraphQlClient(this.connectionManager, this.url, Optional.ofNullable(this.accessToken));
        }
    }
}

