/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.exchange.client.internal;

import java.util.Optional;
import org.mule.tooling.exchange.ExchangeAssetAttributesInfo;
import org.mule.tooling.exchange.client.internal.ExchangeSchema;

public class DefaultExchangeAssetDetailsAttributesInfo
implements ExchangeAssetAttributesInfo {
    private ExchangeSchema.AssetDetails asset;
    private static final String COMMIT_ID = "commit-id";
    private static final String BRANCH_ID = "branch-id";
    private static final String PROJECT_ID = "project-id";
    private static final String ORIGINAL_FORMAT = "original-format";
    private static final String API_VERSION_ID = "product-api-version";
    private static final String ORIGINAL_FORMAT_VERSION = "original-format-version";

    public DefaultExchangeAssetDetailsAttributesInfo(ExchangeSchema.AssetDetails asset) {
        this.asset = asset;
    }

    @Override
    public Optional<String> getDesignCenterProjectId() {
        return this.findAttributeWithId(PROJECT_ID);
    }

    private Optional<String> findAttributeWithId(String attributeKey) {
        return this.asset.getAttributes().stream().filter(attribute -> attributeKey.equals(attribute.getKey())).map(ExchangeSchema.Attribute::getValue).findFirst();
    }

    @Override
    public Optional<String> getDesignCenterProjectBranch() {
        return this.findAttributeWithId(BRANCH_ID);
    }

    @Override
    public Optional<String> getDesignCenterCommitId() {
        return this.findAttributeWithId(COMMIT_ID);
    }

    @Override
    public Optional<String> getOriginalFormat() {
        return this.findAttributeWithId(ORIGINAL_FORMAT);
    }

    @Override
    public Optional<String> getApiVersion() {
        return this.findAttributeWithId(API_VERSION_ID);
    }

    @Override
    public Optional<String> getOriginalFormatVersion() {
        return this.findAttributeWithId(ORIGINAL_FORMAT_VERSION);
    }
}

