/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.exchange.client.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.exchange.ExchangeAssetAttributesInfo;
import org.mule.tooling.exchange.client.internal.ExchangeSchema;

public class DefaultExchangeAsset
implements ExchangeAsset {
    private final ExchangeSchema.Asset asset;
    private ExchangeAssetAttributesInfo exchangeAssetAttributesInfo;

    public DefaultExchangeAsset(ExchangeSchema.Asset asset, ExchangeAssetAttributesInfo exchangeAssetAttributesInfo) {
        this.asset = asset;
        this.exchangeAssetAttributesInfo = exchangeAssetAttributesInfo;
    }

    @Override
    public String getName() {
        return this.asset.getName();
    }

    @Override
    public String getDescription() {
        return this.asset.getDescription();
    }

    @Override
    public String getGroupId() {
        return this.asset.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.asset.getAssetId();
    }

    @Override
    public String getVersion() {
        return this.asset.getVersion();
    }

    @Override
    public String getClassifier() {
        String originalFormat = this.exchangeAssetAttributesInfo.getOriginalFormat().orElse(this.getDefaultClassifier());
        return originalFormat.equals("async-api") ? "evented-api" : originalFormat;
    }

    private String getDefaultClassifier() {
        if ("raml-fragment".equals(this.getType())) {
            return "raml-fragment";
        }
        if ("data-weave-library".equals(this.getType())) {
            return "dw-library";
        }
        return "raml";
    }

    @Override
    public String getOrganizationId() {
        return this.asset.getOrganizationId();
    }

    @Override
    public List<ExchangeAsset> getExtensionDependencies() {
        return Collections.emptyList();
    }

    public String toString() {
        return "DefaultExchangeAsset [getName()=" + this.getName() + ", getVersion()=" + this.getVersion() + this.exchangeAssetAttributesInfo.toString() + "]";
    }

    @Override
    public String getStatus() {
        return this.asset.getStatus();
    }

    @Override
    public ExchangeAssetAttributesInfo getExchangeAssetAttributesInfo() {
        return this.exchangeAssetAttributesInfo;
    }

    @Override
    public String getType() {
        return this.asset.getType();
    }

    @Override
    public String getApiVersion() {
        return this.exchangeAssetAttributesInfo.getApiVersion().orElse(null);
    }

    @Override
    public List<String> getLabels() {
        return this.asset.getLabels();
    }

    @Override
    public List<ExchangeSchema.Category> getCategories() {
        List result = this.asset.getCategories();
        return result != null ? result : new ArrayList();
    }

    @Override
    public List<ExchangeSchema.CustomFieldUnion> getCustomFields() {
        List result = this.asset.getCustomFields();
        return result != null ? result : new ArrayList();
    }

    @Override
    public List<ExchangeSchema.Attribute> getAttributes() {
        return this.asset.getAttributes();
    }
}

