/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.exchange.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.exchange.client.GraphServiceClient;
import org.mule.tooling.exchange.client.internal.ExchangeSchema;

public class GraphServiceQueryBuilder {
    public static final int DEFAULT_LIMIT = 250;
    private static final String JAVA_SUPPORTED_ATTRIBUTE = "is-java-%s-supported";
    private int resultsLimit = 250;
    private boolean includeSnapshots = false;
    private boolean latestVersionOnly;
    private boolean addAttributes = true;
    private boolean addDependencies = true;
    private GraphServiceClient.AssetType[] assetTypes;
    private String searchTerm;
    private String groupId;
    private String artifactId;
    private String version;
    private ExchangeSchema.AttributeSearchField javaSupportedAttribute = null;

    private GraphServiceQueryBuilder() {
    }

    public static Builder create() {
        return new Builder();
    }

    public int getResultsLimit() {
        return this.resultsLimit;
    }

    public String getQuery(int offset, int limit) {
        List<GraphServiceClient.AssetType> list;
        String query = "";
        List<GraphServiceClient.AssetType> list2 = list = this.assetTypes == null ? Collections.emptyList() : Arrays.asList(this.assetTypes);
        if (this.hasCoordinates()) {
            query = this.getAssetCoordinatesQuery(this.groupId, this.artifactId, this.version, this.latestVersionOnly, this.includeSnapshots, list, this.describeAssetDetailsQueryFields());
        } else if (this.searchTerm != null) {
            query = this.getAssetQuery(this.searchTerm, list, offset, limit, this.includeSnapshots);
        }
        return query;
    }

    public boolean hasCoordinates() {
        return this.groupId != null && this.artifactId != null;
    }

    private String getAssetQuery(String searchTerm, List<GraphServiceClient.AssetType> assetTypes, int offset, int limit, Boolean includeSnapshots) {
        String graphqlQueryString = ExchangeSchema.query(query -> query.assets(args -> {
            ExchangeSchema.ExchangeGraphQuery.AssetsArguments assetsArguments = this.describeAssetsQueryArguments(args, searchTerm, assetTypes, offset, limit, includeSnapshots);
        }, asset -> this.describeAssetQueryFields().accept(asset))).toString();
        return graphqlQueryString;
    }

    private String getAssetCoordinatesQuery(String groupId, String artifactId, String version, Boolean lastestVersionOnly, Boolean includeSnapshots, List<GraphServiceClient.AssetType> assetTypes, Consumer<ExchangeSchema.AssetDetailsQuery> assetQueryConsumer) {
        String graphqlQueryString = ExchangeSchema.query(query -> query.asset(groupId, artifactId, argsDef -> {
            ExchangeSchema.ExchangeGraphQuery.AssetArguments assetArguments = this.describeCoordinatesQueryArguments(argsDef, groupId, artifactId, version, lastestVersionOnly, includeSnapshots);
        }, queryDef -> assetQueryConsumer.accept(queryDef))).toString();
        return graphqlQueryString.replace("__typename,", "").replace("CustomField{", "CustomField{__typename,");
    }

    private ExchangeSchema.ExchangeGraphQuery.AssetArguments describeCoordinatesQueryArguments(ExchangeSchema.ExchangeGraphQuery.AssetArguments args, String groupId, String artifactId, String version, Boolean lastestVersionOnly, boolean includeSnapshots) {
        args.version(version);
        ArrayList<ExchangeSchema.Status> statusFilter = new ArrayList<ExchangeSchema.Status>(Arrays.asList(ExchangeSchema.Status.PUBLISHED, ExchangeSchema.Status.DEPRECATED, ExchangeSchema.Status.DEVELOPMENT));
        if (!includeSnapshots) {
            statusFilter.remove(ExchangeSchema.Status.DEVELOPMENT);
        }
        args.status(statusFilter);
        return args;
    }

    private Consumer<ExchangeSchema.AssetQuery> describeAssetQueryFields() {
        return asset -> this.describeAssetFields().accept((ExchangeSchema.AssetQuery)asset);
    }

    private Consumer<ExchangeSchema.AssetQuery> describeAssetFields() {
        return asset -> {
            asset.name();
            asset.type();
            asset.assetId();
            asset.groupId();
            asset.version();
            asset.description();
            asset.organizationId();
            asset.status();
            asset.labels();
            asset.attributes(attribute -> {
                attribute.key();
                attribute.value();
            });
        };
    }

    private Consumer<ExchangeSchema.AssetDetailsQuery> describeAssetDetailsQueryFields() {
        return asset -> {
            this.describeAssetDetailsFields().accept((ExchangeSchema.AssetDetailsQuery)asset);
            if (this.addDependencies) {
                asset.dependencies(dependencies -> this.describeDependencyQueryFields().accept(dependencies));
            }
            asset.otherVersions(otherVersions -> this.describeOtherVersionsQueryFields().accept(otherVersions));
        };
    }

    private Consumer<ExchangeSchema.AssetDetailsQuery> describeAssetDetailsFields() {
        return asset -> {
            asset.name();
            asset.type();
            asset.assetId();
            asset.groupId();
            asset.version();
            asset.description();
            asset.organizationId();
            asset.status();
            asset.labels();
            asset.categories(category -> {
                category.key();
                category.value();
            });
            asset.customFields(customField -> {
                customField.onDateCustomField(dateCustomField -> {
                    dateCustomField.key();
                    dateCustomField.dateValue();
                });
                customField.onEnumCustomField(enumCustomField -> {
                    enumCustomField.key();
                    enumCustomField.enumValue();
                });
                customField.onNumericCustomField(numericCustomField -> {
                    numericCustomField.key();
                    numericCustomField.numberValue();
                });
                customField.onTextCustomField(textCustomField -> {
                    textCustomField.key();
                    textCustomField.textValue();
                });
                customField.onNumericListCustomField(numericListCustomField -> {
                    numericListCustomField.key();
                    numericListCustomField.numberListValue();
                });
                customField.onTextListCustomField(textListCustomField -> {
                    textListCustomField.key();
                    textListCustomField.textListValue();
                });
            });
            if (this.addAttributes) {
                asset.attributes(attribute -> {
                    attribute.key();
                    attribute.value();
                });
            }
        };
    }

    private Consumer<ExchangeSchema.dependencyQuery> describeDependencyQueryFields() {
        return asset -> {
            asset.name();
            asset.type();
            asset.assetId();
            asset.groupId();
            asset.version();
            asset.description();
            asset.organizationId();
            asset.status();
        };
    }

    private Consumer<ExchangeSchema.extendedAssetSchemaQuery> describeOtherVersionsQueryFields() {
        return asset -> {
            asset.name();
            asset.type();
            asset.assetId();
            asset.groupId();
            asset.version();
            asset.description();
            asset.organizationId();
            asset.status();
            asset.labels();
            if (this.addAttributes) {
                asset.attributes(attribute -> {
                    attribute.key();
                    attribute.value();
                });
            }
            if (this.addDependencies) {
                asset.dependencies(dependencies -> this.describeDependencyQueryFields().accept(dependencies));
            }
        };
    }

    private ExchangeSchema.ExchangeGraphQuery.AssetsArguments describeAssetsQueryArguments(ExchangeSchema.ExchangeGraphQuery.AssetsArguments args, String searchTerm, List<GraphServiceClient.AssetType> assetTypes, int offset, int limit, Boolean includeSnapshots) {
        if (!assetTypes.isEmpty()) {
            args.types(assetTypes.stream().map(type -> type.getQueryValue()).collect(Collectors.toList()));
        }
        if (!searchTerm.isEmpty()) {
            args.searchTerm(searchTerm);
        }
        args.offset(Integer.valueOf(offset));
        args.limit(Integer.valueOf(limit));
        if (includeSnapshots.booleanValue()) {
            args.includeSnapshots(includeSnapshots);
        }
        args.latestVersionsOnly(Boolean.valueOf(true));
        ArrayList<ExchangeSchema.AttributeSearchField> attributes = new ArrayList<ExchangeSchema.AttributeSearchField>();
        if (this.javaSupportedAttribute != null && assetTypes.contains((Object)GraphServiceClient.AssetType.EXTENSION)) {
            attributes.add(this.javaSupportedAttribute);
        }
        if (!attributes.isEmpty()) {
            args.attributes(attributes);
        }
        return args;
    }

    public static class Builder {
        private GraphServiceQueryBuilder instance = new GraphServiceQueryBuilder();

        private Builder() {
        }

        public Builder resultsLimit(int resultsLimit) {
            this.instance.resultsLimit = resultsLimit;
            return this;
        }

        public Builder includeSnapshots(boolean includeSnapshots) {
            this.instance.includeSnapshots = includeSnapshots;
            return this;
        }

        public Builder latestVersionOnly(boolean latestVersionOnly) {
            this.instance.latestVersionOnly = latestVersionOnly;
            return this;
        }

        public Builder withSearchTerm(String searchTerm) {
            this.instance.searchTerm = searchTerm;
            return this;
        }

        public Builder withCoordinates(String groupId, String artifactId) {
            this.instance.groupId = groupId;
            this.instance.artifactId = artifactId;
            return this;
        }

        public Builder withCoordinates(String groupId, String artifactId, String version) {
            this.instance.groupId = groupId;
            this.instance.artifactId = artifactId;
            this.instance.version = version;
            return this;
        }

        public Builder withAssetTypes(GraphServiceClient.AssetType ... assetTypes) {
            this.instance.assetTypes = assetTypes;
            return this;
        }

        public Builder ignoreAttributes() {
            this.instance.addAttributes = false;
            return this;
        }

        public Builder ignoreDependencies() {
            this.instance.addDependencies = false;
            return this;
        }

        public Builder filterBySupportedJVM() {
            IMuleProject currentProject = MuleCorePlugin.getDesignContext().getMuleProject();
            String javaVersion = "";
            try {
                javaVersion = ProjectClasspathUtils.getJavaVersion(currentProject.getJavaProject());
            }
            catch (NullPointerException | CoreException throwable) {
                return this;
            }
            if (!javaVersion.isEmpty()) {
                javaVersion = javaVersion.startsWith("1.8") ? "8" : javaVersion.substring(0, 2);
                this.instance.javaSupportedAttribute = new ExchangeSchema.AttributeSearchField(String.format(GraphServiceQueryBuilder.JAVA_SUPPORTED_ATTRIBUTE, javaVersion));
                this.instance.javaSupportedAttribute.setValue("true");
            }
            return this;
        }

        public Builder filterBySupportedJVM(String javaVersion) {
            if (!javaVersion.isEmpty()) {
                javaVersion = javaVersion.startsWith("1.8") ? "8" : javaVersion.substring(0, 2);
                this.instance.javaSupportedAttribute = new ExchangeSchema.AttributeSearchField(String.format(GraphServiceQueryBuilder.JAVA_SUPPORTED_ATTRIBUTE, javaVersion));
                this.instance.javaSupportedAttribute.setValue("true");
            }
            return this;
        }

        public GraphServiceQueryBuilder build() {
            return this.instance;
        }
    }
}

