/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.exchange.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.shopify.graphql.support.SchemaViolationError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.exchange.client.ExternalServiceCallException;
import org.mule.tooling.exchange.client.GraphQlClient;
import org.mule.tooling.exchange.client.GraphServiceQueryBuilder;
import org.mule.tooling.exchange.client.GraphServiceResponse;
import org.mule.tooling.exchange.client.GraphServiceSchemaException;
import org.mule.tooling.exchange.client.internal.DefaultExchangeAsset;
import org.mule.tooling.exchange.client.internal.DefaultExchangeAssetAttributesInfo;
import org.mule.tooling.exchange.client.internal.DefaultExchangeAssetDetails;
import org.mule.tooling.exchange.client.internal.DefaultExchangeAssetDetailsAttributesInfo;
import org.mule.tooling.exchange.client.internal.DefaultExchangeExtendedSchema;
import org.mule.tooling.exchange.client.internal.DefaultExchangeExtendedSchemaAttributesInfo;
import org.mule.tooling.exchange.client.internal.ExchangeSchema;
import org.mule.tooling.exchange.client.internal.FixedListResponse;
import org.mule.tooling.exchange.client.internal.HttpClientGraphQlClient;
import org.mule.tooling.exchange.client.internal.PagingResponse;

public class GraphServiceClient {
    public static final int DEFAULT_LIMIT = 250;
    private static final String DATA = "data";
    private static final String ASSETS_QUERY_TYPE = "assets";
    private static final String ASSET_DETAILS_QUERY_TYPE = "asset";
    private static final Cache<String, GraphServiceClient> clientsCache = CacheBuilder.newBuilder().maximumSize(3L).build();
    private final GraphQlClient exchangeApi;

    static {
        MuleCorePlugin.getEventBus().registerListener(CoreEventTypes.ON_PROXY_CONFIGURATION_CHANGED, () -> clientsCache.invalidateAll());
    }

    public GraphServiceClient(GraphQlClient exchangeApi) {
        this.exchangeApi = exchangeApi;
    }

    public static GraphServiceClient create(String exchangeUrl, Optional<String> accessToken) {
        try {
            return (GraphServiceClient)clientsCache.get((Object)(exchangeUrl + accessToken.orElse("")), () -> {
                HttpClientGraphQlClient exchangeClient = HttpClientGraphQlClient.Builder.create().withUrl(exchangeUrl).withAccessToken(accessToken).build();
                return new GraphServiceClient(exchangeClient);
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public GraphServiceResponse<ExchangeAsset> search(GraphServiceQueryBuilder queryBuilder, Optional<IProgressMonitor> monitor) throws ExternalServiceCallException {
        GraphServiceResponse<ExchangeAsset> response;
        IProgressMonitor progressMonitor = monitor.orElse((IProgressMonitor)new NullProgressMonitor());
        int resultsLimit = queryBuilder.getResultsLimit();
        try {
            String queryType = queryBuilder.hasCoordinates() ? ASSET_DETAILS_QUERY_TYPE : ASSETS_QUERY_TYPE;
            String query = queryBuilder.getQuery(0, resultsLimit);
            List<ExchangeAsset> results = this.executeQuery(query, queryType, progressMonitor);
            response = results.size() >= resultsLimit ? PagingResponse.create(results, (int offset, int limit) -> this.executeQuery(queryBuilder.getQuery(offset, limit), queryType, progressMonitor)) : FixedListResponse.create(results);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    private List<ExchangeAsset> executeQuery(String graphqlQueryString, String queryType, IProgressMonitor monitor) throws ExternalServiceCallException, InterruptedException {
        List<ExchangeAsset> results;
        try {
            String response = this.exchangeApi.query(graphqlQueryString, monitor);
            this.checkResponseErrors(graphqlQueryString, queryType, response);
            ExchangeSchema.QueryResponse graphqlResponse = ExchangeSchema.QueryResponse.fromJson((String)response);
            results = queryType.equals(ASSETS_QUERY_TYPE) ? graphqlResponse.getData().getAssets().stream().map(asset -> new DefaultExchangeAsset((ExchangeSchema.Asset)asset, new DefaultExchangeAssetAttributesInfo((ExchangeSchema.Asset)asset))).collect(Collectors.toList()) : this.getAssetDetailsResponseData(graphqlResponse);
        }
        catch (SchemaViolationError e) {
            throw new GraphServiceSchemaException("Received an invalid response that violates the expected GraphQL schema. Offending field: " + e.getField(), e);
        }
        return results;
    }

    private void checkResponseErrors(String graphqlQueryString, String queryType, String response) throws ExternalServiceCallException {
        Optional<ExternalServiceCallException> responseError = this.checkResponse(graphqlQueryString, response, queryType);
        if (responseError.isPresent()) {
            throw responseError.get();
        }
    }

    private List<ExchangeAsset> getAssetDetailsResponseData(ExchangeSchema.QueryResponse graphqlResponse) {
        ArrayList<ExchangeAsset> processedResults = new ArrayList<ExchangeAsset>();
        ExchangeSchema.AssetDetails queryResponse = graphqlResponse.getData().getAsset();
        DefaultExchangeAssetDetails assetLatestVersion = new DefaultExchangeAssetDetails(queryResponse, new DefaultExchangeAssetDetailsAttributesInfo(queryResponse));
        processedResults.add(assetLatestVersion);
        List otherVersions = queryResponse.getOtherVersions();
        List otherVersionsToAssets = otherVersions.stream().map(asset -> new DefaultExchangeExtendedSchema((ExchangeSchema.extendedAssetSchema)asset, new DefaultExchangeExtendedSchemaAttributesInfo((ExchangeSchema.extendedAssetSchema)asset))).collect(Collectors.toList());
        processedResults.addAll(otherVersionsToAssets);
        return processedResults;
    }

    private Optional<ExternalServiceCallException> checkResponse(String query, String response, String expectedResponseElementName) throws ExternalServiceCallException {
        Optional<ExternalServiceCallException> result = Optional.empty();
        try {
            Map responseMap = (Map)new Gson().fromJson(response, HashMap.class);
            if (responseMap != null && responseMap.containsKey(DATA)) {
                Object data = responseMap.get(DATA);
                if (data == null) {
                    result = Optional.of(ExternalServiceCallException.create("Received empty query response.", responseMap, query, response));
                } else if (data instanceof Map) {
                    Map dataMap = (Map)data;
                    if (!dataMap.containsKey(expectedResponseElementName)) {
                        result = Optional.of(ExternalServiceCallException.create("Missing '" + expectedResponseElementName + "' elements in response data.", responseMap, query, response));
                    }
                } else {
                    result = Optional.of(ExternalServiceCallException.create("Received unexpected query response.", responseMap, query, response));
                }
            } else {
                result = Optional.of(ExternalServiceCallException.create("Received malformed query response.", responseMap, query, response));
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            result = Optional.of(ExternalServiceCallException.create("Received malformed query response.", null, query, response));
        }
        return result;
    }

    public static enum AssetType {
        EXTENSION("extension"),
        CUSTOM("custom"),
        REST_API("rest-api"),
        RAML_FRAGMENT("raml-fragment"),
        DATA_WEAVE_LIBRARY("data-weave-library"),
        EVENTED_API("evented-api");

        private String queryValue;

        private AssetType(String queryValue) {
            this.queryValue = queryValue;
        }

        public String getQueryValue() {
            return this.queryValue;
        }

        public boolean matches(String type) {
            return this.queryValue.equals(type);
        }
    }
}

