/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.exchange.client;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ExternalServiceCallException
extends Exception {
    private static final String ERRORS = "errors";
    private static final String MESSAGE = "message";
    private static final long serialVersionUID = 1L;
    private int statusCode;
    private String reasonPhrase;
    private String query;
    private String response;

    public static ExternalServiceCallException create(String baseMessage, Map<String, Object> responseMap, String query, String response) {
        if (responseMap != null) {
            Object errors = responseMap.get(ERRORS);
            if (errors != null) {
                Collection errorsCollection;
                if (errors instanceof Collection && !(errorsCollection = (Collection)errors).isEmpty()) {
                    String errorsDescription = errorsCollection.stream().map(errorMap -> (String)errorMap.get(MESSAGE)).filter(x -> x != null && !"null".equals(x)).collect(Collectors.joining(". "));
                    return new ExternalServiceCallException(baseMessage + " " + errorsDescription, query, response);
                }
            } else {
                String errorString;
                Object error = responseMap.get("error");
                if (error instanceof String && StringUtils.isNotBlank((String)(errorString = (String)error))) {
                    return new ExternalServiceCallException(baseMessage + " " + errorString, query, response);
                }
            }
        }
        return new ExternalServiceCallException(baseMessage, query, response);
    }

    public ExternalServiceCallException(String message, Throwable cause) {
        super(message, cause);
    }

    private ExternalServiceCallException(String message, String query, String response) {
        super(message);
        this.query = query;
        this.response = response;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    public String getQuery() {
        return this.query;
    }

    public String getResponse() {
        return this.response;
    }

    @Override
    public String toString() {
        return "ExternalServiceCallException [statusCode=" + this.statusCode + ", reasonPhrase=" + this.reasonPhrase + ", query=" + this.query + ", response=" + this.response + "]";
    }
}

