/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.xsd;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.eclipse.xsd.util.DefaultJAXPConfiguration;
import org.mule.tooling.core.xml.XmlFactoryUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class MuleDefaultJAXPConfiguration
extends DefaultJAXPConfiguration {
    public DocumentBuilder createDocumentBuilder(ErrorHandler errorHandler) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = XmlFactoryUtils.createSecureDocumentBuilderFactory();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
        parser.setEntityResolver(this.createEntityResolver());
        parser.setErrorHandler(errorHandler);
        return parser;
    }

    public SAXParser createSAXParser(LexicalHandler lexicalHandler) throws ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = XmlFactoryUtils.createSecureSAXParserFactory();
        saxParserFactory.setNamespaceAware(true);
        saxParserFactory.setValidating(false);
        saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        SAXParser saxParser = saxParserFactory.newSAXParser();
        saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
        return saxParser;
    }

    public Transformer createTransformer(String encoding) throws TransformerException {
        TransformerFactory transformerFactory = XmlFactoryUtils.createSecureTransformerFactory();
        try {
            transformerFactory.setAttribute("indent-number", 2);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        if (encoding != null) {
            transformer.setOutputProperty("encoding", encoding);
        }
        return transformer;
    }
}

