/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.xml.validation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.msg.XMLMessageFormatter;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.parsers.XIncludeAwareParserConfiguration;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.IExternalSchemaLocationProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.ExternalSchemaLocationProviderRegistry;
import org.eclipse.wst.xml.core.internal.validation.AnnotationMsg;
import org.eclipse.wst.xml.core.internal.validation.StreamingMarkupValidator;
import org.eclipse.wst.xml.core.internal.validation.ValidatorHelper;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationConfiguration;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationInfo;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationMessages;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationReport;
import org.eclipse.wst.xml.core.internal.validation.XMLValidator;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationInfo;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.xml.validation.MuleXMLValidationInfo;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MuleXMLValidator
extends XMLValidator {
    private static final boolean _trace = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.xml.core/externalSchemaLocation"));
    private final String ANNOTATIONMSG = AnnotationMsg.class.getName();
    private StreamingMarkupValidator val = new StreamingMarkupValidator();

    public XMLValidationReport validate(String uri, InputStream inputStream, XMLValidationConfiguration configuration, ValidationResult result, NestedValidatorContext context) {
        IReporter reporter;
        String grammarFile = "";
        StringReader reader1 = null;
        StringReader reader2 = null;
        if (inputStream != null) {
            String string = this.createStringForInputStream(inputStream);
            reader1 = new StringReader(string);
            reader2 = new StringReader(string);
        }
        MuleXMLValidationInfo valinfo = new MuleXMLValidationInfo(uri);
        XMLValidator.MyEntityResolver entityResolver = new XMLValidator.MyEntityResolver((XMLValidator)this, this.uriResolver, context);
        ValidatorHelper helper = new ValidatorHelper();
        try {
            boolean isGrammarEncountered;
            helper.computeValidationInformation(uri, (Reader)reader1, this.uriResolver);
            valinfo.setDTDEncountered(helper.isDTDEncountered);
            valinfo.setElementDeclarationCount(helper.numDTDElements);
            valinfo.setNamespaceEncountered(helper.isNamespaceEncountered);
            valinfo.setGrammarEncountered(helper.isGrammarEncountered);
            XMLReader reader = this.createXMLReader(valinfo, (XMLEntityResolver)entityResolver);
            if (configuration.getFeature("HONOUR_ALL_SCHEMA_LOCATIONS")) {
                reader.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
            }
            if (configuration.getFeature("USE_XINCLUDE")) {
                reader.setFeature("http://apache.org/xml/features/xinclude", true);
            }
            if (!(isGrammarEncountered = helper.isGrammarEncountered)) {
                isGrammarEncountered = this.checkExternalSchemas(reader, valinfo.getFileURI());
            }
            reader.setFeature("http://xml.org/sax/features/validation", isGrammarEncountered);
            reader.setFeature("http://apache.org/xml/features/validation/schema", isGrammarEncountered);
            XMLValidator.XMLErrorHandler errorhandler = new XMLValidator.XMLErrorHandler((XMLValidator)this, (XMLValidationInfo)valinfo);
            reader.setErrorHandler((ErrorHandler)errorhandler);
            InputSource inputSource = new InputSource(uri);
            inputSource.setCharacterStream(reader2);
            ClassLoader originalClzLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            try {
                reader.parse(inputSource);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClzLoader);
            }
            if (configuration.getIntFeature("INDICATE_NO_GRAMMAR") > 0 && valinfo.isValid() && !isGrammarEncountered) {
                if (configuration.getIntFeature("INDICATE_NO_GRAMMAR") == 1) {
                    valinfo.addWarning(XMLValidationMessages._WARN_NO_GRAMMAR, 1, 0, uri, "NO_GRAMMAR_FOUND", null);
                } else if (configuration.getIntFeature("INDICATE_NO_GRAMMAR") == 2) {
                    valinfo.addError(XMLValidationMessages._WARN_NO_GRAMMAR, 1, 0, uri, "NO_GRAMMAR_FOUND", null);
                } else {
                    valinfo.addInfo(XMLValidationMessages._WARN_NO_GRAMMAR, 1, 0, uri, "NO_GRAMMAR_FOUND", null);
                }
            }
            if (configuration.getIntFeature("INDICATE_NO_DOCUMENT_ELEMENT") > 0 && valinfo.isValid() && !helper.isDocumentElementEncountered) {
                if (configuration.getIntFeature("INDICATE_NO_DOCUMENT_ELEMENT") == 1) {
                    valinfo.addWarning(XMLValidationMessages._NO_DOCUMENT_ELEMENT, 1, 0, uri, "NO_DOCUMENT_ELEMENT_FOUND", null);
                } else {
                    valinfo.addError(XMLValidationMessages._NO_DOCUMENT_ELEMENT, 1, 0, uri, "NO_DOCUMENT_ELEMENT_FOUND", null);
                }
            }
            grammarFile = helper.isDTDEncountered ? entityResolver.getLocation() : helper.schemaLocationString;
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (IOException ioException) {
            this.addValidationMessage(valinfo, ioException);
        }
        catch (Exception exception) {
            MuleCorePlugin.logError(exception.getLocalizedMessage(), exception);
        }
        if (result != null) {
            try {
                IResource resource = this.getWorkspaceFileFromLocation(grammarFile);
                ArrayList<IResource> resources = new ArrayList<IResource>();
                if (resource != null) {
                    resources.add(resource);
                }
                result.setDependsOn(resources.toArray(new IResource[0]));
            }
            catch (Exception e) {
                MuleCorePlugin.logError(e.getLocalizedMessage(), e);
            }
        }
        if (XMLCorePlugin.getDefault().getPluginPreferences().getBoolean("markupValidation") && (reporter = this.executeMarkupValidator(uri)) != null) {
            List msgList = reporter.getMessages();
            int i = 0;
            while (i < msgList.size()) {
                LocalizedMessage msg = (LocalizedMessage)msgList.get(i);
                if (msg.getSeverity() == 2) {
                    valinfo.addError(msg.getLocalizedMessage(), msg.getLineNumber(), msg.getOffset(), valinfo.getFileURI(), "null", this.getMsgArguments(msg));
                } else if (msg.getSeverity() == 1) {
                    valinfo.addWarning(msg.getLocalizedMessage(), msg.getLineNumber(), msg.getOffset(), valinfo.getFileURI(), "null", this.getMsgArguments(msg));
                }
                ++i;
            }
        }
        return valinfo;
    }

    private Object[] getMsgArguments(LocalizedMessage msg) {
        Object obj = msg.getAttribute(this.ANNOTATIONMSG);
        return new Object[]{obj};
    }

    private IReporter executeMarkupValidator(String uri) {
        Path path = new Path(uri);
        String fileProtocol = "file://";
        int index = uri.indexOf(fileProtocol);
        IFile resource = null;
        if (index == 0) {
            String transformedUri = uri.substring(fileProtocol.length());
            Path transformedPath = new Path(transformedUri);
            resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)transformedPath);
        } else {
            resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        IReporter reporter = null;
        if (resource != null) {
            reporter = this.val.validate((IResource)resource, 0, new ValOperation().getState());
        }
        return reporter;
    }

    private boolean checkExternalSchemas(XMLReader reader, String fileURI) throws Exception {
        boolean isGrammarEncountered = false;
        StringBuffer schemaLocation = new StringBuffer();
        String noNamespaceSchemaLocation = null;
        IExternalSchemaLocationProvider[] providers = ExternalSchemaLocationProviderRegistry.getInstance().getProviders();
        int i = 0;
        while (i < providers.length) {
            URI uri = null;
            try {
                uri = URIUtil.fromString((String)fileURI);
            }
            catch (URISyntaxException e) {
                Logger.logException((String)e.getLocalizedMessage(), (Throwable)e);
            }
            if (uri != null) {
                long diff;
                long time = _trace ? System.currentTimeMillis() : 0L;
                Map locations = providers[i].getExternalSchemaLocation(uri);
                if (_trace && (diff = System.currentTimeMillis() - time) > 250L) {
                    Logger.log((int)1, (String)("Schema location provider took [" + diff + "ms] for URI [" + fileURI + "]"));
                }
                if (locations != null && !locations.isEmpty()) {
                    Object path = locations.get("http://apache.org/xml/properties/schema/external-schemaLocation");
                    if (path instanceof String) {
                        if (schemaLocation.length() > 0) {
                            schemaLocation.append(' ');
                        }
                        schemaLocation.append(path);
                    }
                    if ((path = locations.get("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation")) instanceof String) {
                        noNamespaceSchemaLocation = (String)path;
                    }
                }
            }
            ++i;
        }
        if (schemaLocation.length() > 0) {
            reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", schemaLocation.toString());
            isGrammarEncountered = true;
        }
        if (noNamespaceSchemaLocation != null) {
            reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", noNamespaceSchemaLocation);
            isGrammarEncountered = true;
        }
        return isGrammarEncountered;
    }

    private String createStringForInputStream(InputStream inputStream) {
        StringBuffer fileString = new StringBuffer();
        try {
            InputStreamReader inputReader = new InputStreamReader(inputStream, "UTF-8");
            BufferedReader reader = new BufferedReader(inputReader);
            char[] chars = new char[1024];
            int numberRead = reader.read(chars);
            while (numberRead != -1) {
                fileString.append(chars, 0, numberRead);
                numberRead = reader.read(chars);
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logError("String for Input Stream can not be created.", e);
        }
        return fileString.toString();
    }

    protected XMLReader createXMLReader(final MuleXMLValidationInfo valinfo, XMLEntityResolver entityResolver) throws Exception {
        SAXParser reader = null;
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                MuleStandardParserConfiguration configuration = new MuleStandardParserConfiguration(valinfo);
                reader = new SAXParser((XMLParserConfiguration)configuration){
                    private XMLLocator locator;
                    {
                        super($anonymous0);
                        this.locator = null;
                    }

                    public void startDocument(XMLLocator theLocator, String encoding, NamespaceContext nscontext, Augmentations augs) {
                        this.locator = theLocator;
                        valinfo.setXMLLocator(theLocator);
                        super.startDocument(theLocator, encoding, nscontext, augs);
                    }

                    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
                        valinfo.getStartElementLocations().push(new XMLValidator.LocationCoordinate((XMLValidator)MuleXMLValidator.this, this.locator.getLineNumber(), this.locator.getColumnNumber()));
                        super.startElement(element, attributes, augs);
                    }

                    public void endElement(QName element, Augmentations augs) throws XNIException {
                        super.endElement(element, augs);
                        valinfo.getStartElementLocations().pop();
                    }
                };
                reader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", valinfo.isNamespaceEncountered());
                reader.setFeature("http://xml.org/sax/features/namespaces", valinfo.isNamespaceEncountered());
                reader.setContentHandler(new DefaultHandler(){

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        valinfo.getErrorCustomizationManager().startElement(uri, localName);
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        valinfo.getErrorCustomizationManager().endElement(uri, localName);
                    }
                });
                if (entityResolver != null) {
                    reader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", entityResolver);
                }
                reader.setProperty("http://xml.org/sax/properties/declaration-handler", new XMLValidator.MyDeclHandler((XMLValidator)this));
            }
            catch (Exception e) {
                MuleCorePlugin.logError("XML Reader can not be created.", e);
                Thread.currentThread().setContextClassLoader(prevClassLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
        return reader;
    }

    protected class MuleStandardParserConfiguration
    extends XIncludeAwareParserConfiguration {
        MuleXMLValidationInfo valinfo = null;
        List reportedExceptions = new ArrayList();

        public MuleStandardParserConfiguration(MuleXMLValidationInfo valinfo) {
            this.valinfo = valinfo;
            String xmlCoreId = XMLCorePlugin.getDefault().getBundle().getSymbolicName();
            boolean resolveExternalEntities = InstanceScope.INSTANCE.getNode(xmlCoreId).getBoolean("resolveExternalEntities", false);
            this.setFeature("http://xml.org/sax/features/external-general-entities", resolveExternalEntities);
            this.setFeature("http://xml.org/sax/features/external-parameter-entities", resolveExternalEntities);
            this.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            this.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.resetCommon();
            XMLErrorReporter errorReporter = this.createErrorReporter();
            if (errorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210") == null) {
                XMLMessageFormatter xmft = new XMLMessageFormatter();
                errorReporter.putMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210", (MessageFormatter)xmft);
                errorReporter.putMessageFormatter("http://www.w3.org/TR/1999/REC-xml-names-19990114", (MessageFormatter)xmft);
            }
            this.fErrorReporter = errorReporter;
            this.setProperty("http://apache.org/xml/properties/internal/error-reporter", errorReporter);
            this.fCommonComponents.remove(this.fErrorReporter);
            this.fCommonComponents.add(this.fErrorReporter);
        }

        protected XMLErrorReporter createErrorReporter() {
            return new XMLErrorReporter(){

                public String reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
                    Object location;
                    boolean reportError = true;
                    MuleStandardParserConfiguration.this.valinfo.setCurrentErrorKey(key);
                    MuleStandardParserConfiguration.this.valinfo.setMessageArguments(arguments);
                    String ignoreCondition = (String)MuleXMLValidator.this.ingoredErrorKeyTable.get(key);
                    if (ignoreCondition != null) {
                        boolean isDTDWithoutElementDeclarationEncountered;
                        reportError = ignoreCondition.equals("IGNORE_IF_DTD_WITHOUT_ELEMENT_DECL") ? !(isDTDWithoutElementDeclarationEncountered = MuleStandardParserConfiguration.this.valinfo.isDTDWithoutElementDeclarationEncountered()) : false;
                    }
                    if ("schema_reference.4".equals(key) && arguments.length > 0 && (location = arguments[0]) != null) {
                        if (MuleStandardParserConfiguration.this.reportedExceptions.contains(location)) {
                            reportError = false;
                        } else {
                            MuleStandardParserConfiguration.this.reportedExceptions.add(location);
                        }
                    }
                    if (reportError) {
                        String formattedError = super.reportError(domain, key, arguments, severity);
                        MuleStandardParserConfiguration.this.valinfo.getErrorCustomizationManager().considerReportedError((ValidationInfo)MuleStandardParserConfiguration.this.valinfo, key, arguments);
                        return formattedError;
                    }
                    return null;
                }
            };
        }
    }
}

