/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.xml.format;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.core.xml.format.XmlFormatProcessor;

public class XmlIndentWithTabs
implements XmlFormatProcessor {
    private static final Pattern INITIAL_SPACES_PATTERN = Pattern.compile("([ ]+)");
    private static final String TAB = "\t";
    private int quantitySpaces;

    public XmlIndentWithTabs(int quantitySpaces) {
        this.quantitySpaces = quantitySpaces;
    }

    @Override
    public String process(String line) {
        Matcher matcher = INITIAL_SPACES_PATTERN.matcher(line);
        if (!matcher.lookingAt()) {
            return line;
        }
        String spaces = matcher.group(1);
        int quantity = spaces.length() / this.quantitySpaces;
        String newLine = StringUtils.repeat((String)TAB, (int)quantity) + line.substring(quantity * this.quantitySpaces);
        return newLine;
    }
}

