/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.xml.format;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.xml.format.XmlFormatProcessor;
import org.mule.tooling.core.xml.format.XmlIndentWithTabs;
import org.mule.tooling.core.xml.format.XmlLineTrimmer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlFormatter {
    private static final String WST_XML_CORE_PLUGIN_ID = "org.eclipse.wst.xml.core";
    private static final String TAB = "tab";
    private static final String INDENTATION_CHAR = "indentationChar";
    private static final String PLATFORM_TEXT_PLUGIN_ID = "org.eclipse.ui.editors";
    private static final String INDENTATION_DISPLAY_WIDTH = "tabWidth";
    private static XPathExpression NORMALIZE_SPACE_XPATH_EXPRESSION = XmlFormatter.buildNormalizeSpaceXpathExpression();
    private static Pattern EXTRA_NEWLINES_PATTERN = Pattern.compile("^\\n(\\n+)");

    private static XPathExpression buildNormalizeSpaceXpathExpression() {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        try {
            return xpathFactory.newXPath().compile("//text()[normalize-space(.) = '']");
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static int getIndentationSize() {
        return Platform.getPreferencesService().getInt(PLATFORM_TEXT_PLUGIN_ID, INDENTATION_DISPLAY_WIDTH, 4, null);
    }

    public static String getIndentationChar() {
        return Platform.getPreferencesService().getString(WST_XML_CORE_PLUGIN_ID, INDENTATION_CHAR, TAB, null);
    }

    public static void removeWhitespaceNodes(Node node) {
        try {
            NodeList emptyTextNodes = (NodeList)NORMALIZE_SPACE_XPATH_EXPRESSION.evaluate(node, XPathConstants.NODESET);
            int i = 0;
            while (i < emptyTextNodes.getLength()) {
                Node emptyTextNode = emptyTextNodes.item(i);
                Matcher matcher = EXTRA_NEWLINES_PATTERN.matcher(emptyTextNode.getTextContent());
                if (matcher.lookingAt()) {
                    emptyTextNode.setNodeValue(matcher.group(1));
                } else {
                    emptyTextNode.getParentNode().removeChild(emptyTextNode);
                }
                ++i;
            }
        }
        catch (XPathExpressionException xPathExpressionException) {}
    }

    public static void postProcess(File file) {
        XmlFormatProcessor[] processors = XmlFormatter.buildXmlProcessors();
        XmlFormatter.postProcess(file, processors);
    }

    public static void postProcess(File file, XmlFormatProcessor[] processors) {
        String NL = System.lineSeparator();
        try {
            StringWriter output = new StringWriter();
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedWriter writer = new BufferedWriter(output);){
                CDATAState state = new CDATAState();
                Throwable throwable2 = null;
                Object var9_15 = null;
                try (Stream<String> lines = Files.lines(Paths.get(file.toURI()));){
                    lines.forEachOrdered(line -> {
                        try {
                            state.updateState((String)line);
                            if (state.mustPassthrough()) {
                                writer.write((String)line);
                            } else {
                                writer.write(XmlFormatter.processLine(line, processors));
                            }
                            writer.write(NL);
                        }
                        catch (IOException e) {
                            MuleCorePlugin.logError("Error while post-processing XML file: " + file.getAbsolutePath(), e);
                        }
                    });
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            try {
                try {
                    Files.writeString(file.toPath(), (CharSequence)output.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (Exception e) {
                    MuleCorePlugin.logError("Error writing the post-processed XML file: " + file.getAbsolutePath(), e);
                    output.close();
                }
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logError("Error post-processing XML file: " + file.getAbsolutePath(), e);
        }
    }

    private static XmlFormatProcessor[] buildXmlProcessors() {
        String indentationChar = XmlFormatter.getIndentationChar();
        if (TAB.equals(indentationChar)) {
            int indentationSize = XmlFormatter.getIndentationSize();
            return new XmlFormatProcessor[]{new XmlLineTrimmer(), new XmlIndentWithTabs(indentationSize)};
        }
        return new XmlFormatProcessor[]{new XmlLineTrimmer()};
    }

    private static String processLine(String line, XmlFormatProcessor[] processors) throws IOException {
        String processedLine = line;
        XmlFormatProcessor[] xmlFormatProcessorArray = processors;
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            XmlFormatProcessor processor = xmlFormatProcessorArray[n2];
            processedLine = processor.process(processedLine);
            ++n2;
        }
        return processedLine;
    }

    private static class CDATAState {
        private static final String CDATA_START_TOKEN = "<![CDATA[";
        private static final String CDATA_END_TOKEN = "]]>";
        private boolean containsCDATAStart;
        private boolean containsCDATAEnd;
        private boolean passthrough;

        private CDATAState() {
        }

        void updateState(String line) {
            this.containsCDATAStart = line.contains(CDATA_START_TOKEN);
            this.containsCDATAEnd = line.contains(CDATA_END_TOKEN);
            if (this.containsCDATAStart) {
                this.setPassthrough();
            }
            if (this.containsCDATAEnd) {
                this.clearPassthrough();
            }
        }

        void setPassthrough() {
            this.passthrough = true;
        }

        void clearPassthrough() {
            this.passthrough = false;
        }

        boolean mustPassthrough() {
            return !this.containsCDATAStart && this.passthrough;
        }
    }
}

